/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="set-scm-tag", aggregator=true, threadSafe=true)
public class SetScmTagMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="newTag")
    private String newTag;
    @Parameter(property="connection")
    private String connection;
    @Parameter(property="developerConnection")
    private String developerConnection;
    @Parameter(property="url")
    private String url;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public SetScmTagMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.validateInput();
        if (this.session.getProjects().size() != this.session.getAllProjects().size()) {
            for (MavenProject currentProject : this.session.getProjects()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Processing " + currentProject.getGroupId() + ":" + currentProject.getArtifactId() + ":" + currentProject.getVersion() + "..."));
                }
                this.execute(currentProject);
            }
        } else {
            this.execute(this.session.getCurrentProject());
        }
    }

    private void execute(MavenProject currentProject) throws MojoExecutionException, MojoFailureException {
        File outFile = currentProject.getFile();
        this.process(outFile);
    }

    @Override
    protected void validateInput() throws MojoExecutionException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.newTag, this.connection, this.developerConnection, this.url})) {
            throw new MojoExecutionException("One of: \"newTag\", \"connection\", \"developerConnection\", \"url\" should be provided.");
        }
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            Scm scm = PomHelper.getRawModel((String)pom.getSource(), (File)pom.getFileName().toFile()).getScm();
            if (scm == null) {
                throw new MojoFailureException("No <scm> was present");
            }
            ArrayList<String> failures = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)this.newTag)) {
                this.getLog().info((CharSequence)("Updating tag: " + (scm.getTag() != null ? scm.getTag() : "(empty)") + " -> " + this.newTag));
                if (!PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"tag", (String)this.newTag)) {
                    failures.add("tag: " + this.newTag);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.connection)) {
                this.getLog().info((CharSequence)("Updating connection: " + (scm.getConnection() != null ? scm.getConnection() : "(empty)") + " -> " + this.connection));
                if (!PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"connection", (String)this.connection)) {
                    failures.add("connection: " + this.connection);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.developerConnection)) {
                this.getLog().info((CharSequence)("Updating developerConnection: " + (scm.getDeveloperConnection() != null ? scm.getDeveloperConnection() : "(empty)") + " -> " + this.developerConnection));
                if (!PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"developerConnection", (String)this.developerConnection)) {
                    failures.add("developerConnection: " + this.developerConnection);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.url)) {
                this.getLog().info((CharSequence)("Updating url: " + (scm.getUrl() != null ? scm.getUrl() : "(empty)") + " -> " + this.url));
                if (!PomHelper.setElementValue((MutableXMLStreamReader)pom, (String)"/project/scm", (String)"url", (String)this.url)) {
                    failures.add("url: " + this.url);
                }
            }
            if (!failures.isEmpty()) {
                throw new MojoFailureException("Could not update one or more SCM elements: " + String.join((CharSequence)", ", failures) + ". Please make sure they are present in the original POM. ");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

