/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.ship.BeanShellScriptEngine;
import org.codehaus.mojo.ship.GroovyScriptEngine;
import org.codehaus.mojo.ship.ScriptEngine;
import org.codehaus.mojo.ship.ScriptException;
import org.codehaus.mojo.ship.WagonScriptEngine;
import org.codehaus.plexus.util.FileUtils;

public class ScriptEngineManager {
    private final Set engines = new LinkedHashSet();

    public ScriptEngineManager() {
        this.engines.add(new BeanShellScriptEngine());
        this.engines.add(new GroovyScriptEngine());
        this.engines.add(new WagonScriptEngine());
    }

    public Object eval(File script, Map globalVariables, Log log) throws MojoExecutionException {
        ScriptEngine engine = null;
        Iterator i = this.engines.iterator();
        while (i.hasNext()) {
            ScriptEngine e = (ScriptEngine)i.next();
            if (!script.getName().endsWith("." + e.getExtension())) continue;
            engine = e;
            break;
        }
        if (engine == null) {
            throw new MojoExecutionException("Could not find a script engine to execute " + script);
        }
        try {
            return engine.eval(FileUtils.fileRead((File)script), globalVariables);
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Ship script failed", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

