/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.plugin.logging.Log;

public class ColorConsoleLogger
implements Log {
    private static final int ATTR_DIM = 2;
    private static final int FG_RED = 31;
    private static final int FG_GREEN = 32;
    private static final int FG_MAGENTA = 35;
    private static final int FG_CYAN = 36;
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m";
    private static final char SEPARATOR = ';';
    private static final String END_COLOR = "\u001b[m";
    private String errColor = "\u001b[2;31m";
    private String warnColor = "\u001b[2;35m";
    private String infoColor = "\u001b[2;36m";
    private String debugColor = "\u001b[2;32m";
    private Log realLogger;

    public ColorConsoleLogger(Log realLogger) {
        this.realLogger = realLogger;
    }

    public boolean isDebugEnabled() {
        return this.realLogger.isDebugEnabled();
    }

    public void debug(CharSequence content) {
        this.realLogger.debug((CharSequence)(this.debugColor + content + END_COLOR));
    }

    public void debug(CharSequence content, Throwable error) {
        this.debug(content + "\n\n" + this.formatError(error));
    }

    public void debug(Throwable error) {
        this.debug(this.formatError(error));
    }

    public boolean isInfoEnabled() {
        return this.realLogger.isInfoEnabled();
    }

    public void info(CharSequence content) {
        this.realLogger.info((CharSequence)(this.infoColor + content + END_COLOR));
    }

    public void info(CharSequence content, Throwable error) {
        this.info(content + "\n\n" + this.formatError(error));
    }

    public void info(Throwable error) {
        this.info(this.formatError(error));
    }

    public boolean isWarnEnabled() {
        return this.realLogger.isWarnEnabled();
    }

    public void warn(CharSequence content) {
        this.realLogger.warn((CharSequence)(this.warnColor + content + END_COLOR));
    }

    public void warn(CharSequence content, Throwable error) {
        this.warn(content + "\n\n" + this.formatError(error));
    }

    public void warn(Throwable error) {
        this.warn(this.formatError(error));
    }

    public boolean isErrorEnabled() {
        return this.realLogger.isErrorEnabled();
    }

    public void error(CharSequence content) {
        this.realLogger.error((CharSequence)(this.errColor + content + END_COLOR));
    }

    public void error(CharSequence content, Throwable error) {
        this.error(content + "\n\n" + this.formatError(error));
    }

    public void error(Throwable error) {
        this.error(this.formatError(error));
    }

    private String formatError(Throwable error) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        error.printStackTrace(pWriter);
        return sWriter.toString();
    }
}

