/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.changelog.log.grammar;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.scmchangelog.changelog.log.Issue;
import org.codehaus.mojo.scmchangelog.changelog.log.Message;
import org.codehaus.mojo.scmchangelog.changelog.log.OperationTypeEnum;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.AbstractScmGrammar;

public class BugzillaScmGrammar
extends AbstractScmGrammar {
    private static final Pattern BUGZILLA_PATTERN = Pattern.compile("bug\\s+#?([1-9][0-9]*)", 2);

    public Message extractMessage(String content) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Matcher matcher = BUGZILLA_PATTERN.matcher(content);
        while (matcher.find()) {
            issues.add(new Issue(matcher.group(1), OperationTypeEnum.FIX));
        }
        return new Message(content, issues);
    }

    public String getIssueSeparator() {
        return "\r\n";
    }

    public boolean hasMessage(String content) {
        Matcher matcher = BUGZILLA_PATTERN.matcher(content);
        return matcher.find();
    }
}

