/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:scmchangelog-maven-plugin:1.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven SCM Changelog Reporter", 0);
        this.append(sb, "Simple Reporter that creates a changelog report using comments and tags from the SCM.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "scmchangelog:help", 0);
            this.append(sb, "Display help information on scmchangelog-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0scmchangelog:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "scmchangelog:report", 0);
            this.append(sb, "Goal which produces a changelog report based on the Subversion logs.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat (Default: yyyy-MM-dd)", 2);
                this.append(sb, "Used to specify the date format of the log entries that are retrieved from your SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filter", 2);
                this.append(sb, "The regexp used to filter tags and branches names to produce the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "grammar (Default: MANU)", 2);
                this.append(sb, "Grammar name for parsing svn logs", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "", 0);
                this.append(sb, "releasesOrder (Default: historic)", 2);
                this.append(sb, "Used to specify if the releases should be ordered alphabetally or historically. Supported values are historic and alphabetic.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampFormat (Default: dd/MM/yyyy HH:mm)", 2);
                this.append(sb, "Used to specify the date format of the log entries that are retrieved from your SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trackerType (Default: ${project.issueManagement.system})", 2);
                this.append(sb, "Used to specify the tracker type.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trackerUrlPattern (Default: ${project.issueManagement.url})", 2);
                this.append(sb, "Used to specify the tracker issue url pattern.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn and starteam protocol).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

