/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.platform.detective;

import java.util.List;
import java.util.Map;
import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.SystemArchitectureDetector;
import org.codehaus.mojo.tools.platform.SystemDistributionDetector;
import org.codehaus.mojo.tools.platform.detective.PlatformDetective;
import org.codehaus.mojo.tools.platform.detective.PlatformPropertyPatterns;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultPlatformDetective
implements Contextualizable,
LogEnabled,
PlatformDetective {
    public static final String ROLE_HINT = "default";
    private String rawOSInfo;
    private String architecture;
    private String releaseSource;
    private Context containerContext;
    private PlexusContainer container;
    private Logger logger;

    public String getArchitectureToken() throws PlatformDetectionException {
        this.scanArchitectureInfo();
        return this.architecture;
    }

    public String getOperatingSystemToken() throws PlatformDetectionException, ComponentLookupException {
        this.scanOperatingSystemInfo();
        PlatformPropertyPatterns platformPatterns = this.getPlatformPatterns();
        return platformPatterns.getOperatingSystemToken(this.releaseSource, this.rawOSInfo);
    }

    protected PlatformPropertyPatterns getPlatformPatterns() throws ComponentLookupException {
        return PlatformPropertyPatterns.DEFAULT_PATTERNS;
    }

    protected void scanOperatingSystemInfo() throws PlatformDetectionException {
        if (this.rawOSInfo == null) {
            Map distroDetectors;
            try {
                distroDetectors = this.container.lookupMap(SystemDistributionDetector.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new PlatformDetectionException("Cannot lookup system distribution detector components.", e);
            }
            for (Map.Entry entry : distroDetectors.entrySet()) {
                String roleHint = (String)entry.getKey();
                SystemDistributionDetector detector = (SystemDistributionDetector)entry.getValue();
                this.getLogger().debug("Detector: " + detector.getClass().getName() + " enabled: " + detector.isEnabled());
                if (detector.isEnabled()) {
                    this.getLogger().debug("Applying OS detector: " + roleHint);
                    this.releaseSource = detector.getDistributionInfoSource();
                    this.getLogger().debug("releaseSource = " + this.releaseSource);
                    this.rawOSInfo = detector.getDistributionInfo();
                    continue;
                }
                this.getLogger().debug("Skipping OS detector: " + roleHint);
            }
            if (this.rawOSInfo == null) {
                throw new PlatformDetectionException("Failed to detect distribution info for " + System.getProperty("os.name"));
            }
        }
    }

    protected void scanArchitectureInfo() throws PlatformDetectionException {
        if (this.architecture == null) {
            List archDetectors;
            try {
                archDetectors = this.container.lookupList(SystemArchitectureDetector.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new PlatformDetectionException("Cannot lookup system architecture detector components.", e);
            }
            for (SystemArchitectureDetector detector : archDetectors) {
                if (!detector.isEnabled()) continue;
                this.architecture = detector.getSystemArchitecture();
            }
            if (this.architecture == null) {
                throw new PlatformDetectionException("Failed to detect architecture info for " + System.getProperty("os.name") + ".  A common reason for this is RPM is not installed");
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.containerContext = context;
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

