/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rmic.NoSuchRmiCompilerException;
import org.codehaus.mojo.rmic.RmiCompiler;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.mojo.rmic.RmiCompilerManager;
import org.codehaus.mojo.rmic.RmicConfig;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRmiMojo
extends AbstractMojo
implements RmicConfig {
    protected Set includes;
    protected Set excludes;
    protected String compilerId;
    private String version;
    private boolean iiop;
    private boolean noLocalStubs;
    private boolean idl;
    private boolean noValueMethods;
    private boolean keep;
    private boolean nowarn;
    private boolean verbose;
    private int staleMillis;
    private RmiCompilerManager rmiCompilerManager;
    protected MavenProject project;
    static /* synthetic */ Class class$java$rmi$Remote;

    public abstract List getProjectClasspathElements();

    public abstract File getOutputDirectory();

    public abstract File getClassesDirectory();

    public void execute() throws MojoExecutionException {
        RmiCompiler rmiCompiler;
        if (this.includes == null) {
            this.includes = Collections.singleton("**/*");
        }
        if (this.excludes == null) {
            this.excludes = new HashSet();
        }
        this.excludes.add("**/*_Stub.class");
        try {
            rmiCompiler = this.rmiCompilerManager.getRmiCompiler(this.compilerId);
        }
        catch (NoSuchRmiCompilerException e) {
            throw new MojoExecutionException("No such RMI compiler installed '" + this.compilerId + "'.");
        }
        if (!this.getOutputDirectory().isDirectory() && !this.getOutputDirectory().mkdirs()) {
            throw new MojoExecutionException("Could not make output directory: '" + this.getOutputDirectory().getAbsolutePath() + "'.");
        }
        try {
            List remoteClassesToCompile = this.scanForRemoteClasses();
            if (remoteClassesToCompile.size() == 0) {
                this.getLog().info((CharSequence)"No out of date rmi classes to process.");
                return;
            }
            this.getLog().info((CharSequence)("Compiling " + remoteClassesToCompile.size() + " remote classes"));
            rmiCompiler.execute(this, remoteClassesToCompile);
        }
        catch (RmiCompilerException e) {
            throw new MojoExecutionException("Error while executing the RMI compiler.", (Exception)e);
        }
    }

    public List getRmicClasspathElements() {
        List classpathElements = this.getProjectClasspathElements();
        if (!classpathElements.contains(this.getClassesDirectory().getAbsolutePath())) {
            classpathElements.add(this.getClassesDirectory().getAbsolutePath());
        }
        return classpathElements;
    }

    public List scanForRemoteClasses() {
        ArrayList<String> remoteClasses = new ArrayList<String>();
        try {
            List classpathList = this.generateUrlCompileClasspath();
            URL[] classpathUrls = new URL[classpathList.size()];
            classpathUrls[0] = this.getClassesDirectory().toURL();
            classpathUrls = classpathList.toArray(classpathUrls);
            URLClassLoader loader = new URLClassLoader(classpathUrls);
            StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
            scanner.addSourceMapping((SourceMapping)new SuffixMapping(".class", "_Stub.class"));
            Set staleRemoteClasses = scanner.getIncludedSources(this.getClassesDirectory(), this.getOutputDirectory());
            Iterator iter = staleRemoteClasses.iterator();
            while (iter.hasNext()) {
                URI relativeURI;
                String className;
                Class<?> remoteClass;
                File remoteClassFile = (File)iter.next();
                if (!(class$java$rmi$Remote == null ? AbstractRmiMojo.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(remoteClass = loader.loadClass(className = StringUtils.replace((String)StringUtils.replace((String)(relativeURI = this.getClassesDirectory().toURI().relativize(remoteClassFile.toURI())).toString(), (String)".class", (String)""), (String)"/", (String)"."))) || remoteClass.isInterface() && !this.isIiop()) continue;
                remoteClasses.add(className);
            }
            iter = this.includes.iterator();
            while (iter.hasNext()) {
                String include = (String)iter.next();
                File includeFile = new File(this.getClassesDirectory(), include);
                if (include.indexOf("*") != -1 || includeFile.exists()) continue;
                String fqClassName = StringUtils.replace((String)StringUtils.replace((String)include, (String)".class", (String)""), (String)"/", (String)".");
                remoteClasses.add(fqClassName);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Problem while scanning for classes: " + e));
        }
        return remoteClasses;
    }

    protected List generateUrlCompileClasspath() throws MojoExecutionException {
        ArrayList<URL> rmiCompileClasspath = new ArrayList<URL>();
        try {
            rmiCompileClasspath.add(this.getClassesDirectory().toURL());
            Iterator iter = this.getRmicClasspathElements().iterator();
            while (iter.hasNext()) {
                URL pathUrl = new File((String)iter.next()).toURL();
                rmiCompileClasspath.add(pathUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Problem while generating classpath: " + e.getMessage());
        }
        return rmiCompileClasspath;
    }

    public String getCompilerId() {
        return this.compilerId;
    }

    public boolean isIiop() {
        return this.iiop;
    }

    public boolean isIdl() {
        return this.idl;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoLocalStubs() {
        return this.noLocalStubs;
    }

    public boolean isNoValueMethods() {
        return this.noValueMethods;
    }
}

