/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.project.archive.AbstractProjectSourcesMojo;
import org.codehaus.plexus.util.FileUtils;

public class RelocateProjectSourcesMojo
extends AbstractProjectSourcesMojo {
    private File from;
    private boolean skipPomProjects;
    private File to;
    private boolean copyOnly;

    public void execute() throws MojoExecutionException {
        if (this.skipPomProjects && "pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Relocate mojo: skipping 'pom' project.");
            return;
        }
        if (!this.from.exists()) {
            throw new MojoExecutionException("Cannot find original source directory ('from' directory): " + this.from + ".");
        }
        this.to.mkdirs();
        try {
            FileUtils.copyDirectoryStructure((File)this.from, (File)this.to);
            if (!this.copyOnly) {
                FileUtils.deleteDirectory((File)this.from);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to relocate project sources from: " + this.from + " to: " + this.to, (Exception)e);
        }
    }
}

