/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jpox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

public abstract class AbstractJpoxMojo
extends AbstractMojo {
    protected File classes;
    private List classpathElements;
    protected List pluginArtifacts;
    private String mappingIncludes;
    private String mappingExcludes;

    public void execute() throws MojoExecutionException {
        if (!this.classes.exists()) {
            throw new MojoExecutionException("Specified classes directory '" + this.classes.getAbsolutePath() + "' is not available.");
        }
        List files = this.findMappingFiles();
        if (files.size() == 0) {
            this.getLog().warn((CharSequence)("No files to run Jpox tool '" + this.getToolName() + "'"));
            return;
        }
        this.getLog().debug((CharSequence)("Classes Dir is : " + this.classes.getAbsolutePath()));
        URL log4jProperties = ((Object)((Object)this)).getClass().getResource("/log4j.configuration");
        try {
            this.executeJpoxTool(this.pluginArtifacts, log4jProperties, files);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing the JPox tool '" + this.getToolName() + "'.", (Exception)((Object)e));
        }
    }

    protected List findMappingFiles() throws MojoExecutionException {
        List files;
        try {
            files = FileUtils.getFiles((File)this.classes, (String)this.mappingIncludes, (String)this.mappingExcludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for mapping files in '" + this.classes.getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    protected List getUniqueClasspathElements() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.classes.getAbsolutePath());
        Iterator it = this.classpathElements.iterator();
        while (it.hasNext()) {
            String pathelem = (String)it.next();
            if (ret.contains(new File(pathelem).getAbsolutePath())) continue;
            ret.add(pathelem);
        }
        return ret;
    }

    protected abstract void executeJpoxTool(List var1, URL var2, List var3) throws CommandLineException, MojoExecutionException;

    protected abstract String getToolName();
}

