/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.locale;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.AbstractLogAwareFacet;

public class LocaleFacet
extends AbstractLogAwareFacet {
    private Locale originalLocale;
    private Locale newLocale;

    public LocaleFacet(Log log, Locale newLocale) {
        super(log);
        Validate.notNull(newLocale, "usedLocale");
        this.originalLocale = Locale.getDefault();
        this.newLocale = newLocale;
    }

    @Override
    public void setup() {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Setting default locale to [" + this.newLocale + "]"));
        }
        try {
            Locale.setDefault(this.newLocale);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not switch locale to [" + this.newLocale + "]. Continuing with standard locale."), (Throwable)e);
        }
    }

    @Override
    public void restore() {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Restoring default locale to [" + this.originalLocale + "]"));
        }
        try {
            Locale.setDefault(this.originalLocale);
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Could not restore locale to [" + this.originalLocale + "]. Continuing with [" + Locale.getDefault() + "]"), (Throwable)e);
        }
    }

    public static LocaleFacet createFor(String localeString, Log log) throws MojoExecutionException {
        Validate.notNull(log, "log");
        Validate.notEmpty(localeString, "localeString");
        StringTokenizer tok = new StringTokenizer(localeString, ",", false);
        int numTokens = tok.countTokens();
        if (numTokens > 3 || numTokens == 0) {
            throw new MojoExecutionException("A localeString must consist of up to 3 comma-separated parts on the form <language>[,<country>[,<variant>]]. Received incorrect value '" + localeString + "'");
        }
        Locale locale = null;
        switch (numTokens) {
            case 3: {
                locale = new Locale(tok.nextToken().trim(), tok.nextToken().trim(), tok.nextToken().trim());
                break;
            }
            case 2: {
                locale = new Locale(tok.nextToken().trim(), tok.nextToken().trim());
                break;
            }
            default: {
                locale = new Locale(tok.nextToken().trim());
            }
        }
        return new LocaleFacet(log, locale);
    }
}

