/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.cassandra.cli.CliMain;
import org.apache.cassandra.tools.NodeCmd;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.OS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.cassandra.CassandraMonitor;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractCassandraMojo
extends AbstractMojo {
    protected File cassandraDir;
    protected MavenProject project;
    private File classesDirectory;
    private File testClassesDirectory;
    protected boolean addTestClasspath;
    protected boolean addMainClasspath;
    protected boolean skip;
    private List<Artifact> pluginDependencies;
    private Artifact pluginArtifact;
    protected MavenSession session;
    private String yaml;
    protected String rpcAddress;
    protected int rpcPort;
    protected int jmxPort;
    protected String listenAddress;
    protected int storagePort;
    protected int stopPort;
    protected String stopKey;
    protected int maxMemory;
    protected String keyspace;

    protected void createCassandraJar(File jarFile, String mainClass) throws IOException {
        this.createCassandraJar(jarFile, mainClass, this.cassandraDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCassandraJar(File jarFile, String mainClass, File cassandraDir) throws IOException {
        File conf = new File(cassandraDir, "conf");
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(jarFile);
            jos = new JarOutputStream(fos);
            jos.setLevel(0);
            jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            Manifest man = new Manifest();
            StringBuilder cp = new StringBuilder();
            cp.append(new URL(conf.toURI().toASCIIString()).toExternalForm());
            cp.append(' ');
            this.getLog().debug((CharSequence)("Adding plugin artifact: " + ArtifactUtils.versionlessKey((Artifact)this.pluginArtifact) + " to the classpath"));
            cp.append(new URL(this.pluginArtifact.getFile().toURI().toASCIIString()).toExternalForm());
            cp.append(' ');
            for (Artifact artifact : this.pluginDependencies) {
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + ArtifactUtils.versionlessKey((Artifact)artifact) + " to the classpath"));
                cp.append(new URL(artifact.getFile().toURI().toASCIIString()).toExternalForm());
                cp.append(' ');
            }
            if (this.addMainClasspath || this.addTestClasspath) {
                if (this.addTestClasspath) {
                    this.getLog().debug((CharSequence)("Adding: " + this.testClassesDirectory + " to the classpath"));
                    cp.append(new URL(this.testClassesDirectory.toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
                if (this.addMainClasspath) {
                    this.getLog().debug((CharSequence)("Adding: " + this.classesDirectory + " to the classpath"));
                    cp.append(new URL(this.classesDirectory.toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
                for (Artifact artifact : this.project.getArtifacts()) {
                    if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) && !this.addTestClasspath) continue;
                    this.getLog().debug((CharSequence)("Adding dependency: " + ArtifactUtils.versionlessKey((Artifact)artifact) + " to the classpath"));
                    cp.append(new URL(artifact.getFile().toURI().toASCIIString()).toExternalForm());
                    cp.append(' ');
                }
            }
            man.getMainAttributes().putValue("Manifest-Version", "1.0");
            man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            man.getMainAttributes().putValue("Main-Class", mainClass);
            man.write(jos);
        }
        catch (Throwable throwable) {
            IOUtil.close(jos);
            IOUtil.close((OutputStream)fos);
            throw throwable;
        }
        IOUtil.close((OutputStream)jos);
        IOUtil.close((OutputStream)fos);
    }

    protected void createCassandraHome() throws IOException {
        this.createCassandraHome(this.cassandraDir, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress});
    }

    protected void createCassandraHome(File cassandraDir, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds) throws IOException {
        File nodetoolJar;
        File cassandraCliJar;
        File cassandraJar;
        File log4jClientProperties;
        File log4jServerProperties;
        File bin = new File(cassandraDir, "bin");
        File conf = new File(cassandraDir, "conf");
        File data = new File(cassandraDir, "data");
        File commitlog = new File(cassandraDir, "commitlog");
        File savedCaches = new File(cassandraDir, "saved_caches");
        for (File dir : Arrays.asList(cassandraDir, bin, conf, data, commitlog, savedCaches)) {
            if (dir.isFile()) {
                this.getLog().debug((CharSequence)("Deleting file " + dir + " as we need to create a directory with the same name."));
                if (!dir.delete()) {
                    this.getLog().warn((CharSequence)("Could not delete file " + dir));
                }
            }
            if (dir.isDirectory()) continue;
            this.getLog().debug((CharSequence)("Creating directory " + dir + " as it does not exist."));
            if (dir.mkdirs()) continue;
            this.getLog().warn((CharSequence)("Could not create directory " + dir));
        }
        File cassandraYaml = new File(conf, "cassandra.yaml");
        if (Utils.shouldGenerateResource(this.project, cassandraYaml)) {
            this.getLog().debug((CharSequence)((cassandraYaml.isFile() ? "Updating " : "Creating ") + cassandraYaml));
            this.createCassandraYaml(cassandraYaml, data, commitlog, savedCaches, listenAddress, rpcAddress, initialToken, seeds);
        }
        if (Utils.shouldGenerateResource(this.project, log4jServerProperties = new File(conf, "log4j-server.properties"))) {
            this.getLog().debug((CharSequence)((log4jServerProperties.isFile() ? "Updating " : "Creating ") + log4jServerProperties));
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/log4j.properties"), (File)log4jServerProperties);
        }
        if (Utils.shouldGenerateResource(this.project, log4jClientProperties = new File(conf, "log4j-client.properties"))) {
            this.getLog().debug((CharSequence)((log4jClientProperties.isFile() ? "Updating " : "Creating ") + log4jClientProperties));
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/log4j.properties"), (File)log4jClientProperties);
        }
        if (Utils.shouldGenerateResource(this.project, cassandraJar = new File(bin, "cassandra.jar"))) {
            this.getLog().debug((CharSequence)((cassandraJar.isFile() ? "Updating " : "Creating ") + cassandraJar));
            this.createCassandraJar(cassandraJar, CassandraMonitor.class.getName(), cassandraDir);
        }
        if (Utils.shouldGenerateResource(this.project, cassandraCliJar = new File(bin, "cassandra-cli.jar"))) {
            this.getLog().debug((CharSequence)((cassandraCliJar.isFile() ? "Updating " : "Creating ") + cassandraCliJar));
            this.createCassandraJar(cassandraCliJar, CliMain.class.getName(), cassandraDir);
        }
        if (Utils.shouldGenerateResource(this.project, nodetoolJar = new File(bin, "nodetool.jar"))) {
            this.getLog().debug((CharSequence)((nodetoolJar.isFile() ? "Updating " : "Creating ") + nodetoolJar));
            this.createCassandraJar(nodetoolJar, NodeCmd.class.getName(), cassandraDir);
        }
    }

    private void createCassandraYaml(File cassandraYaml, File data, File commitlog, File savedCaches) throws IOException {
        this.createCassandraYaml(cassandraYaml, data, commitlog, savedCaches, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress});
    }

    private void createCassandraYaml(File cassandraYaml, File data, File commitlog, File savedCaches, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds) throws IOException {
        String defaults = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cassandra.yaml"));
        StringBuilder config = new StringBuilder();
        config.append("data_file_directories:\n").append("    - ").append(data.getAbsolutePath()).append("\n");
        config.append("commitlog_directory: ").append(commitlog).append("\n");
        config.append("saved_caches_directory: ").append(savedCaches).append("\n");
        config.append("initial_token: ").append(initialToken == null ? "" : initialToken.toString()).append("\n");
        config.append("listen_address: ").append(listenAddress).append("\n");
        config.append("storage_port: ").append(this.storagePort).append("\n");
        config.append("rpc_address: ").append(rpcAddress).append("\n");
        config.append("rpc_port: ").append(this.rpcPort).append("\n");
        if (seeds != null) {
            config.append("seed_provider: ").append("\n");
            config.append("    - class_name: org.apache.cassandra.locator.SimpleSeedProvider").append("\n");
            config.append("      parameters:").append("\n");
            String sep = "          - seeds: \"";
            for (int i = 0; i < seeds.length; ++i) {
                config.append(sep).append(seeds[i]);
                sep = ", ";
            }
            if (sep.length() == 2) {
                config.append("\"").append("\n");
            }
        }
        FileUtils.fileWrite((String)cassandraYaml.getAbsolutePath(), (String)Utils.merge(Utils.merge(defaults, this.yaml), config.toString()));
    }

    protected Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    protected CommandLine newJavaCommandLine() {
        String exec = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in cassandra-maven-plugin: " + tc));
            exec = tc.findTool("java");
        } else if (OS.isFamilyWindows()) {
            String ex = "java.exe";
            String path = System.getenv("PATH");
            if (path != null) {
                for (String elem : StringUtils.split((String)path, (String)File.pathSeparator)) {
                    File f = new File(new File(elem), ex);
                    if (!f.exists()) continue;
                    exec = ex;
                    break;
                }
            }
        }
        if (exec == null) {
            exec = "java";
        }
        return new CommandLine(exec);
    }

    protected Map<String, String> createEnvironmentVars() {
        HashMap<String, String> enviro = new HashMap<String, String>();
        try {
            Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
                enviro.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException x) {
            this.getLog().error((CharSequence)"Could not assign default system enviroment variables.", (Throwable)x);
        }
        enviro.put("CASSANDRA_CONF", new File(this.cassandraDir, "conf").getAbsolutePath());
        return enviro;
    }

    protected CommandLine newServiceCommandLine() throws IOException {
        return this.newServiceCommandLine(this.cassandraDir, this.listenAddress, this.rpcAddress, null, new String[]{this.listenAddress}, true, this.jmxPort);
    }

    protected CommandLine newServiceCommandLine(File cassandraDir, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds, boolean jmxRemoteEnabled, int jmxPort) throws IOException {
        this.createCassandraHome(cassandraDir, listenAddress, rpcAddress, initialToken, seeds);
        CommandLine commandLine = this.newJavaCommandLine();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Xmx" + this.maxMemory + "m");
        if (this.stopKey != null && this.stopPort > 0 && this.stopPort < 65536) {
            args.add("-DSTOP.KEY=" + this.stopKey);
            args.add("-DSTOP.PORT=" + this.stopPort);
            args.add("-DSTOP.HOST=" + listenAddress);
        }
        try {
            args.add("-Dlog4j.configuration=" + new File(new File(cassandraDir, "conf"), "log4j-server.properties").toURL().toURI().toString());
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        args.add("-Dcom.sun.management.jmxremote=" + jmxRemoteEnabled);
        if (jmxRemoteEnabled) {
            args.add("-Dcom.sun.management.jmxremote.port=" + jmxPort);
            args.add("-Dcom.sun.management.jmxremote.ssl=false");
            args.add("-Dcom.sun.management.jmxremote.authenticate=false");
        }
        args.add("-jar");
        args.add(new File(new File(cassandraDir, "bin"), "cassandra.jar").toString());
        commandLine.addArguments(args.toArray(new String[args.size()]), true);
        return commandLine;
    }

    protected CommandLine newCliCommandLine(String ... args) throws IOException {
        this.createCassandraHome();
        CommandLine commandLine = this.newJavaCommandLine();
        ArrayList<String> args1 = new ArrayList<String>();
        args1.add("-jar");
        args1.add(new File(new File(this.cassandraDir, "bin"), "cassandra-cli.jar").toString());
        args1.add("--host");
        args1.add(this.rpcAddress);
        args1.add("--port");
        args1.add(Integer.toString(this.rpcPort));
        args1.add("--jmxport");
        args1.add(Integer.toString(this.jmxPort));
        args1.addAll(Arrays.asList(args));
        commandLine.addArguments(args1.toArray(new String[args1.size()]), true);
        return commandLine;
    }

    protected CommandLine newNodetoolCommandLine(String ... args) throws IOException {
        this.createCassandraHome();
        CommandLine commandLine = this.newJavaCommandLine();
        ArrayList<String> args1 = new ArrayList<String>();
        args1.add("-jar");
        args1.add(new File(new File(this.cassandraDir, "bin"), "nodetool.jar").toString());
        args1.add("--host");
        args1.add("127.0.0.1");
        args1.add("--port");
        args1.add(Integer.toString(this.jmxPort));
        args1.addAll(Arrays.asList(args));
        commandLine.addArguments(args1.toArray(new String[args1.size()]), true);
        return commandLine;
    }
}

