/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml.metadata;

import java.util.Collections;
import java.util.Map;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.MetadataPlugin;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;

public class XmlMetadataPlugin
extends AbstractMetadataPlugin
implements MetadataPlugin {
    public static final String XML_ATTRIBUTE = "xml.attribute";
    static final String XML_CONTENT = "xml._content_";
    public static final String XML_FORMAT = "xml.format";
    public static final String XML_ITEMS_STYLE = "xml.itemsStyle";
    public static final String XML_MAP_STYLE = "xml.mapStyle";
    public static final String XML_NAMESPACE = "xml.namespace";
    public static final String XML_REFERENCE = "xml.reference";
    public static final String XML_SCHEMA_LOCATION = "xml.schemaLocation";
    public static final String XML_TAG_NAME = "xml.tagName";
    public static final String XML_TRIM = "xml.trim";
    public static final String XML_TRANSIENT = "xml.transient";

    public ModelMetadata getModelMetadata(Model model, Map data) {
        XmlModelMetadata metadata = new XmlModelMetadata();
        metadata.setNamespace(this.getString(data, XML_NAMESPACE));
        metadata.setSchemaLocation(this.getString(data, XML_SCHEMA_LOCATION));
        return metadata;
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) {
        XmlClassMetadata metadata = new XmlClassMetadata();
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) {
        XmlFieldMetadata metadata = new XmlFieldMetadata();
        metadata.setAttribute(this.getBoolean(data, XML_ATTRIBUTE, false));
        metadata.setContent(this.getBoolean(data, XML_CONTENT, false));
        metadata.setTrim(this.getBoolean(data, XML_TRIM, true));
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        metadata.setFormat(this.getString(data, XML_FORMAT));
        metadata.setTransient(this.getBoolean(data, XML_TRANSIENT, false));
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) {
        XmlAssociationMetadata metadata = new XmlAssociationMetadata();
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        metadata.setItemsStyle(this.getString(data, XML_ITEMS_STYLE));
        metadata.setMapStyle(this.getString(data, XML_MAP_STYLE));
        metadata.setReference(this.getBoolean(data, XML_REFERENCE, false));
        return metadata;
    }

    public Map getFieldMap(ModelField field, FieldMetadata metadata) {
        return Collections.EMPTY_MAP;
    }
}

