/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JNaming;
import org.codehaus.modello.plugin.java.javasource.JType;

public class JField
implements JMember {
    private JModifiers modifiers = null;
    private JType type = null;
    private String name = null;
    private JDocComment comment = null;
    private String initString = null;
    private JAnnotations annotations = null;
    private JClass declaringClass = null;

    public JField(JType type, String name) {
        this.setName(name);
        this.type = type;
        this.modifiers = new JModifiers();
        this.modifiers.makePrivate();
        this.comment = new JDocComment();
        this.comment.appendComment("Field " + name + ".");
        this.annotations = new JAnnotations();
    }

    public JDocComment getComment() {
        return this.comment;
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String getInitString() {
        return this.initString;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public JType getType() {
        return this.type;
    }

    public void setComment(JDocComment comment) {
        this.comment = comment;
    }

    public void setComment(String comment) {
        if (this.comment == null) {
            this.comment = new JDocComment();
        }
        this.comment.setComment(comment);
    }

    public void setInitString(String init) {
        this.initString = init;
    }

    public void setName(String name) throws IllegalArgumentException {
        if (!JNaming.isValidJavaIdentifier(name)) {
            String err = "'" + name + "' is ";
            err = JNaming.isKeyword(name) ? err + "a reserved word and may not be used as  a field name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this.name = name;
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers;
    }

    protected void setDeclaringClass(JClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.modifiers.toString());
        sb.append(' ');
        sb.append(this.type);
        sb.append(' ');
        sb.append(this.name);
        return sb.toString();
    }

    public JAnnotations getAnnotations() {
        return this.annotations;
    }

    public void appendAnnotation(String annotation) {
        if (this.annotations == null) {
            this.annotations = new JAnnotations();
        }
        this.annotations.appendAnnotation(annotation);
    }

    public void setAnnotations(JAnnotations annotations) {
        this.annotations = annotations;
    }
}

