/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.converters;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.model.VersionDefinition;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.JavaClassMetadata;
import org.codehaus.modello.plugin.java.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;

public class ConverterGenerator
extends AbstractModelloGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        String[] versions = parameters.getProperty("modello.all.versions").split(",");
        ArrayList<Version> allVersions = new ArrayList<Version>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            allVersions.add(new Version(versions[i]));
        }
        Collections.sort(allVersions);
        Version nextVersion = null;
        Iterator i = allVersions.iterator();
        while (i.hasNext() && nextVersion == null) {
            Version v = (Version)i.next();
            if (!v.greaterThan(this.getGeneratedVersion())) continue;
            nextVersion = v;
        }
        this.generateConverters(nextVersion);
        if (nextVersion == null) {
            this.generateConverterTool(allVersions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConverters(Version nextVersion) throws ModelloException {
        Model objectModel = this.getModel();
        Version generatedVersion = this.getGeneratedVersion();
        String packageName = objectModel.getDefaultPackageName(true, generatedVersion) + ".convert";
        String jDoc = "Converts between version " + generatedVersion + " and version " + nextVersion + " of the model.";
        JInterface conversionInterface = new JInterface("VersionConverter");
        conversionInterface.getJDocComment().setComment(jDoc);
        conversionInterface.setPackageName(packageName);
        JClass basicConverterClass = new JClass("BasicVersionConverter");
        basicConverterClass.getJDocComment().setComment(jDoc);
        basicConverterClass.setPackageName(packageName);
        basicConverterClass.addInterface(conversionInterface);
        VersionDefinition versionDefinition = objectModel.getVersionDefinition();
        Iterator i = objectModel.getClasses(generatedVersion).iterator();
        while (i.hasNext()) {
            ModelClass modelClass = (ModelClass)i.next();
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled() || nextVersion != null && !nextVersion.inside(modelClass.getVersionRange())) continue;
            String methodName = "convert" + modelClass.getName();
            String parameterName = ConverterGenerator.uncapitalise((String)modelClass.getName());
            String sourceClass = ConverterGenerator.getSourceClassName(modelClass, generatedVersion);
            String targetClass = modelClass.getPackageName(nextVersion != null, nextVersion) + "." + modelClass.getName();
            if (!javaClassMetadata.isAbstract()) {
                JMethodSignature methodSig = new JMethodSignature(methodName, new JType(targetClass));
                methodSig.addParameter(new JParameter(new JType(sourceClass), parameterName));
                conversionInterface.addMethod(methodSig);
                JMethod jMethod = new JMethod(new JType(targetClass), methodName);
                jMethod.addParameter(new JParameter(new JType(sourceClass), parameterName));
                basicConverterClass.addMethod(jMethod);
                JSourceCode sc = jMethod.getSourceCode();
                sc.add("return " + methodName + "( " + parameterName + ", new " + targetClass + "() );");
            }
            JMethod jMethod = new JMethod(new JType(targetClass), methodName);
            jMethod.addParameter(new JParameter(new JType(sourceClass), parameterName));
            jMethod.addParameter(new JParameter(new JType(targetClass), "value"));
            basicConverterClass.addMethod(jMethod);
            JSourceCode sc = jMethod.getSourceCode();
            sc.add("if ( " + parameterName + " == null )");
            sc.add("{");
            sc.indent();
            sc.add("return null;");
            sc.unindent();
            sc.add("}");
            if (modelClass.getSuperClass() != null) {
                sc.add("// Convert super class");
                sc.add("value = (" + targetClass + ") convert" + modelClass.getSuperClass() + "( " + parameterName + ", value );");
                sc.add("");
            }
            Iterator j = modelClass.getFields(generatedVersion).iterator();
            while (j.hasNext()) {
                ModelField modelField = (ModelField)j.next();
                String name = this.capitalise(modelField.getName());
                if (nextVersion != null && versionDefinition != null && "field".equals(versionDefinition.getType()) && (versionDefinition.getValue().equals(modelField.getName()) || versionDefinition.getValue().equals(modelField.getAlias()))) {
                    sc.add("value.set" + name + "( \"" + nextVersion + "\" );");
                    continue;
                }
                if (nextVersion != null && !nextVersion.inside(modelField.getVersionRange())) {
                    ModelField newField = null;
                    try {
                        newField = modelClass.getField(modelField.getName(), nextVersion);
                    }
                    catch (ModelloRuntimeException e) {
                        continue;
                    }
                    if (!newField.getType().equals(modelField.getType())) continue;
                }
                if (modelField instanceof ModelAssociation) {
                    ModelAssociation assoc = (ModelAssociation)modelField;
                    if ("*".equals(assoc.getMultiplicity())) {
                        String className;
                        String type = assoc.getType();
                        if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                            sc.add("{");
                            sc.indent();
                            sc.add(assoc.getType() + " list = " + assoc.getDefaultValue() + ";");
                            sc.add("for ( java.util.Iterator i = " + parameterName + ".get" + name + "().iterator(); i.hasNext(); )");
                            sc.add("{");
                            sc.indent();
                            if (this.isClassInModel(assoc.getTo(), modelClass.getModel())) {
                                className = ConverterGenerator.getSourceClassName(assoc.getToClass(), generatedVersion);
                                sc.add(className + " v = (" + className + ") i.next();");
                            } else {
                                sc.add(assoc.getTo() + " v = (" + assoc.getTo() + ") i.next();");
                            }
                            if (this.isClassInModel(assoc.getTo(), objectModel)) {
                                sc.add("list.add( convert" + assoc.getTo() + "( v ) );");
                            } else {
                                sc.add("list.add( v );");
                            }
                            sc.unindent();
                            sc.add("}");
                            sc.add("value.set" + name + "( list );");
                            sc.unindent();
                            sc.add("}");
                            continue;
                        }
                        sc.add("{");
                        sc.indent();
                        sc.add(assoc.getType() + " map = " + assoc.getDefaultValue() + ";");
                        sc.add("for ( java.util.Iterator i = " + parameterName + ".get" + name + "().entrySet().iterator(); i.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("java.util.Map.Entry entry = (java.util.Map.Entry) i.next();");
                        if (this.isClassInModel(assoc.getTo(), modelClass.getModel())) {
                            className = ConverterGenerator.getSourceClassName(assoc.getToClass(), generatedVersion);
                            sc.add(className + " v = (" + className + ") entry.getValue();");
                        } else {
                            sc.add(assoc.getTo() + " v = (" + assoc.getTo() + ") entry.getValue();");
                        }
                        if (this.isClassInModel(assoc.getTo(), objectModel)) {
                            sc.add("map.put( entry.getKey(), convert" + assoc.getTo() + "( v ) );");
                        } else {
                            sc.add("map.put( entry.getKey(), v );");
                        }
                        sc.unindent();
                        sc.add("}");
                        sc.add("value.set" + name + "( map );");
                        sc.unindent();
                        sc.add("}");
                        continue;
                    }
                    sc.add("value.set" + name + "( convert" + assoc.getTo() + "( " + parameterName + ".get" + name + "() ) );");
                    continue;
                }
                sc.add("// Convert field " + modelField.getName());
                JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
                String value = parameterName + "." + this.getPrefix(javaFieldMetadata) + name + "()";
                sc.add("value.set" + name + "( " + value + " );");
            }
            sc.add("");
            sc.add("return value;");
        }
        String directory = packageName.replace('.', '/');
        File dir = new File(this.getOutputDirectory(), directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Writer interfaceWriter = this.getFileWriter(dir, "VersionConverter.java");
        Writer classWriter = this.getFileWriter(dir, "BasicVersionConverter.java");
        try {
            conversionInterface.print(new JSourceWriter(interfaceWriter));
            basicConverterClass.print(new JSourceWriter(classWriter));
        }
        finally {
            IOUtil.close((Writer)classWriter);
            IOUtil.close((Writer)interfaceWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConverterTool(List allVersions) throws ModelloException {
        Model objectModel = this.getModel();
        String basePackage = objectModel.getDefaultPackageName(false, null);
        String packageName = basePackage + ".convert";
        String jDoc = "Converts between the available versions of the model.";
        JClass converterClass = new JClass("ConverterTool");
        converterClass.getJDocComment().setComment(jDoc);
        converterClass.setPackageName(packageName);
        converterClass.addImport("java.io.File");
        converterClass.addImport("java.io.IOException");
        converterClass.addImport("javax.xml.stream.*");
        Iterator i = allVersions.iterator();
        while (i.hasNext()) {
            Version v = (Version)i.next();
            ConverterGenerator.writeConvertMethod(converterClass, objectModel, basePackage, allVersions, v);
        }
        ConverterGenerator.writeConvertMethod(converterClass, objectModel, basePackage, allVersions, null);
        String directory = packageName.replace('.', '/');
        File dir = new File(this.getOutputDirectory(), directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Writer classWriter = this.getFileWriter(dir, "ConverterTool.java");
        try {
            converterClass.print(new JSourceWriter(classWriter));
        }
        finally {
            IOUtil.close((Writer)classWriter);
        }
    }

    private static void writeConvertMethod(JClass converterClass, Model objectModel, String basePackage, List allVersions, Version v) {
        String targetPackage = objectModel.getDefaultPackageName(v != null, v);
        String targetClass = targetPackage + ".Model";
        String methodName = "convertFromFile";
        if (v != null) {
            methodName = methodName + "_" + v.toString("v", "_");
        }
        JMethod method = new JMethod(new JType(targetClass), methodName);
        method.addParameter(new JParameter(new JType("File"), "f"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        converterClass.addMethod(method);
        JSourceCode sc = method.getSourceCode();
        sc.add(basePackage + ".io.stax.MavenStaxReaderDelegate reader = new " + basePackage + ".io.stax.MavenStaxReaderDelegate();");
        sc.add("Object value = reader.read( f );");
        String prefix = "";
        Iterator j = allVersions.iterator();
        while (j.hasNext()) {
            Version sourceVersion = (Version)j.next();
            String sourcePackage = objectModel.getDefaultPackageName(true, sourceVersion);
            String sourceClass = sourcePackage + ".Model";
            sc.add(prefix + "if ( value instanceof " + sourceClass + " )");
            sc.add("{");
            sc.indent();
            boolean foundFirst = false;
            Iterator k = allVersions.iterator();
            while (k.hasNext()) {
                Version targetVersion = (Version)k.next();
                if (!foundFirst) {
                    if (!targetVersion.equals((Object)sourceVersion)) continue;
                    foundFirst = true;
                }
                if (targetVersion.equals((Object)v)) break;
                String p = objectModel.getDefaultPackageName(true, targetVersion);
                String c = p + ".Model";
                sc.add("value = new " + p + ".convert.BasicVersionConverter().convertModel( (" + c + ") value );");
            }
            sc.unindent();
            sc.add("}");
            prefix = "else ";
            if (!sourceVersion.equals((Object)v)) continue;
            break;
        }
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("throw new IllegalStateException( \"Can't find converter for class '\" + value.getClass() + \"'\" );");
        sc.unindent();
        sc.add("}");
        sc.add("return (" + targetClass + ") value;");
    }

    private static String getSourceClassName(ModelClass modelClass, Version generatedVersion) {
        return modelClass.getPackageName(true, generatedVersion) + "." + modelClass.getName();
    }

    private Writer getFileWriter(File dir, String name) throws ModelloException {
        Writer writer;
        File f = new File(dir, name);
        try {
            writer = this.getEncoding() == null ? WriterFactory.newPlatformWriter((File)f) : WriterFactory.newWriter((File)f, (String)this.getEncoding());
        }
        catch (IOException e) {
            throw new ModelloException("Unable to generate: " + f + "; reason: " + e.getMessage(), (Throwable)e);
        }
        return writer;
    }
}

