/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.core.ModelloCore;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelValidationException;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractModelloGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private String basedir;
    @Parameter(required=true)
    private String[] models;
    @Parameter(property="version", required=true)
    private String version;
    @Parameter(property="packageWithVersion", defaultValue="false", required=true)
    private boolean packageWithVersion;
    @Component
    private ModelloCore modelloCore;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private List<String> packagedVersions = new ArrayList<String>();
    @Component
    private BuildContext buildContext;

    protected abstract String getGeneratorType();

    public abstract File getOutputDirectory();

    protected boolean producesCompilableResult() {
        return false;
    }

    protected boolean producesResources() {
        return false;
    }

    protected Properties createParameters() {
        return new Properties();
    }

    protected void customizeParameters(Properties parameters) {
    }

    public void execute() throws MojoExecutionException {
        String outputDirectory = this.getOutputDirectory().getAbsolutePath();
        this.getLog().info((CharSequence)("outputDirectory: " + outputDirectory));
        Properties parameters = this.createParameters();
        parameters.setProperty("modello.output.directory", outputDirectory);
        parameters.setProperty("modello.version", this.version);
        parameters.setProperty("modello.package.with.version", Boolean.toString(this.packageWithVersion));
        if (this.packagedVersions.size() > 0) {
            parameters.setProperty("modello.all.versions", StringUtils.join(this.packagedVersions.iterator(), (String)","));
        }
        this.customizeParameters(parameters);
        MojoExecutionException firstError = null;
        for (String modelStr : this.models) {
            try {
                this.doExecute(modelStr, outputDirectory, parameters);
            }
            catch (MojoExecutionException e) {
                if (firstError == null) {
                    firstError = e;
                }
                this.getLog().error((Throwable)e);
            }
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    private void doExecute(String modelStr, String outputDirectory, Properties parameters) throws MojoExecutionException {
        if (!this.buildContext.hasDelta(modelStr)) {
            this.getLog().debug((CharSequence)("Skipping unchanged model: " + modelStr));
            return;
        }
        this.getLog().info((CharSequence)("Working on model: " + modelStr));
        File modelFile = new File(this.basedir, modelStr);
        this.buildContext.removeMessages(modelFile);
        try {
            Model model = this.modelloCore.loadModel(modelFile);
            this.getLog().info((CharSequence)("Generating current version: " + this.version));
            this.modelloCore.generate(model, this.getGeneratorType(), parameters);
            for (String version : this.packagedVersions) {
                parameters.setProperty("modello.version", version);
                parameters.setProperty("modello.package.with.version", Boolean.toString(true));
                this.getLog().info((CharSequence)("Generating packaged version: " + version));
                this.modelloCore.generate(model, this.getGeneratorType(), parameters);
            }
            if (this.producesCompilableResult() && this.project != null) {
                this.project.addCompileSourceRoot(outputDirectory);
            }
            if (this.producesResources() && this.project != null) {
                Resource resource = new Resource();
                resource.setDirectory(outputDirectory);
                this.project.addResource(resource);
            }
        }
        catch (FileNotFoundException e) {
            MojoExecutionException mojoExecutionException = new MojoExecutionException(e.getMessage(), (Exception)e);
            this.buildContext.addMessage(modelFile, 1, 1, mojoExecutionException.getMessage(), 2, (Throwable)mojoExecutionException);
            throw mojoExecutionException;
        }
        catch (ModelloException e) {
            MojoExecutionException mojoExecutionException = new MojoExecutionException("Error generating: " + e.getMessage(), (Exception)((Object)e));
            this.buildContext.addMessage(modelFile, 1, 1, mojoExecutionException.getMessage(), 2, (Throwable)mojoExecutionException);
            throw mojoExecutionException;
        }
        catch (ModelValidationException e) {
            MojoExecutionException mojoExecutionException = new MojoExecutionException("Error generating: " + e.getMessage(), (Exception)((Object)e));
            this.buildContext.addMessage(modelFile, 1, 1, mojoExecutionException.getMessage(), 2, (Throwable)mojoExecutionException);
            throw mojoExecutionException;
        }
        catch (IOException e) {
            MojoExecutionException mojoExecutionException = new MojoExecutionException("Couldn't read file: " + e.getMessage(), (Exception)e);
            this.buildContext.addMessage(modelFile, 1, 1, mojoExecutionException.getMessage(), 2, (Throwable)mojoExecutionException);
            throw mojoExecutionException;
        }
        catch (RuntimeException e) {
            MojoExecutionException mojoExecutionException = new MojoExecutionException("Error generating: " + e.getMessage(), (Exception)e);
            this.buildContext.addMessage(modelFile, 1, 1, mojoExecutionException.getMessage(), 2, (Throwable)mojoExecutionException);
            throw mojoExecutionException;
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getPackageWithVersion() {
        return this.packageWithVersion;
    }

    public void setPackageWithVersion(boolean packageWithVersion) {
        this.packageWithVersion = packageWithVersion;
    }

    public ModelloCore getModelloCore() {
        return this.modelloCore;
    }

    public void setModelloCore(ModelloCore modelloCore) {
        this.modelloCore = modelloCore;
    }

    public void setBuildContext(BuildContext context) {
        this.buildContext = context;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setPackagedVersions(List<String> packagedVersions) {
        this.packagedVersions = Collections.unmodifiableList(packagedVersions);
    }

    public String[] getModels() {
        return this.models;
    }

    public void setModels(String[] models) {
        this.models = models;
    }
}

