/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.script.Interpreter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUpdateOverlay;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    public static final int ALWAYS_INTERACTIVE = 3;
    public static final String SCRIPT_ALERT = "script.alert";
    public static final String SCRIPT_PROMPT = "script.prompt";
    public static final String SCRIPT_CONFIRM = "script.confirm";
    public static final String BROKEN_LINK_TITLE = "broken.link.title";
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected boolean isInteractiveDocument;
    protected boolean selfCallingDisableInteractions = false;
    protected boolean userSetDisableInteractions = false;
    protected int documentState;
    protected Dimension prevComponentSize;
    protected Runnable afterStopRunnable = null;
    protected SVGUpdateOverlay updateOverlay;
    protected boolean recenterOnResize = true;
    protected AffineTransform viewingTransform = null;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected JSVGComponentListener jsvgComponentListener = new JSVGComponentListener();
    protected static final Set FEATURES = new HashSet();

    public JSVGComponent() {
        this(null, false, false);
    }

    public JSVGComponent(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.svgUserAgent = sVGUserAgent;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
        if (this.updateOverlay != null) {
            this.getOverlays().add(this.updateOverlay);
        }
    }

    public void dispose() {
        this.setSVGDocument(null);
    }

    @Override
    public void setDisableInteractions(boolean bl) {
        super.setDisableInteractions(bl);
        if (!this.selfCallingDisableInteractions) {
            this.userSetDisableInteractions = true;
        }
    }

    public void clearUserSetDisableInteractions() {
        this.userSetDisableInteractions = false;
        this.updateZoomAndPanEnable((Document)this.svgDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateZoomAndPanEnable(Document document) {
        if (this.userSetDisableInteractions) {
            return;
        }
        if (document == null) {
            return;
        }
        try {
            Element element = document.getDocumentElement();
            String string = element.getAttributeNS(null, "zoomAndPan");
            boolean bl = "magnify".equals(string);
            this.selfCallingDisableInteractions = true;
            this.setDisableInteractions(!bl);
        }
        finally {
            this.selfCallingDisableInteractions = false;
        }
    }

    public boolean getRecenterOnResize() {
        return this.recenterOnResize;
    }

    public void setRecenterOnResize(boolean bl) {
        this.recenterOnResize = bl;
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public boolean isInteractive() {
        return this.isInteractiveDocument;
    }

    public void setDocumentState(int n) {
        this.documentState = n;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    @Override
    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.halt();
        }
        if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.halt();
        }
        if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.halt();
        }
        if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        }
        if (this.updateManager != null) {
            this.updateManager.interrupt();
        }
        super.stopProcessing();
    }

    public void loadSVGDocument(String string) {
        String string2 = null;
        if (this.svgDocument != null) {
            string2 = this.svgDocument.getURL();
        }
        final ParsedURL parsedURL = new ParsedURL(string2, string);
        this.stopThenRun(new Runnable(){

            @Override
            public void run() {
                String string = parsedURL.toString();
                JSVGComponent.this.fragmentIdentifier = parsedURL.getRef();
                JSVGComponent.this.loader = new DocumentLoader(JSVGComponent.this.userAgent);
                JSVGComponent.this.nextDocumentLoader = new SVGDocumentLoader(string, JSVGComponent.this.loader);
                JSVGComponent.this.nextDocumentLoader.setPriority(1);
                Iterator iterator = JSVGComponent.this.svgDocumentLoaderListeners.iterator();
                while (iterator.hasNext()) {
                    JSVGComponent.this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)iterator.next());
                }
                JSVGComponent.this.startDocumentLoader();
            }
        });
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setDocument(Document document) {
        if (document != null && !(document.getImplementation() instanceof SVGDOMImplementation)) {
            Document document2;
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            document = document2 = DOMUtilities.deepCloneDocument(document, dOMImplementation);
        }
        this.setSVGDocument((SVGDocument)document);
    }

    public void setSVGDocument(SVGDocument sVGDocument) {
        Object object;
        if (sVGDocument != null && !(sVGDocument.getImplementation() instanceof SVGDOMImplementation)) {
            object = SVGDOMImplementation.getDOMImplementation();
            Document document = DOMUtilities.deepCloneDocument((Document)sVGDocument, (DOMImplementation)object);
            sVGDocument = (SVGDocument)document;
        }
        object = sVGDocument;
        this.stopThenRun(new Runnable((SVGDocument)object){
            final /* synthetic */ SVGDocument val$svgdoc;
            {
                this.val$svgdoc = sVGDocument;
            }

            @Override
            public void run() {
                JSVGComponent.this.installSVGDocument(this.val$svgdoc);
            }
        });
    }

    protected void stopThenRun(Runnable runnable) {
        if (this.afterStopRunnable != null) {
            this.afterStopRunnable = runnable;
            return;
        }
        this.afterStopRunnable = runnable;
        this.stopProcessing();
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.nextUpdateManager == null && this.updateManager == null) {
            Runnable runnable2 = this.afterStopRunnable;
            this.afterStopRunnable = null;
            runnable2.run();
        }
    }

    protected void installSVGDocument(SVGDocument sVGDocument) {
        this.svgDocument = sVGDocument;
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
            this.bridgeContext = null;
        }
        this.releaseRenderingReferences();
        if (sVGDocument == null) {
            this.isDynamicDocument = false;
            this.isInteractiveDocument = false;
            this.disableInteractions = true;
            this.initialTransform = new AffineTransform();
            this.setRenderingTransform(this.initialTransform, false);
            Rectangle rectangle = this.getRenderRect();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        this.bridgeContext = this.createBridgeContext((SVGOMDocument)sVGDocument);
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = false;
                break;
            }
            case 3: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = true;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                this.isInteractiveDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = this.bridgeContext.isDynamicDocument((Document)sVGDocument);
                boolean bl = this.isInteractiveDocument = this.isDynamicDocument || this.bridgeContext.isInteractiveDocument((Document)sVGDocument);
            }
        }
        if (this.isInteractiveDocument) {
            if (this.isDynamicDocument) {
                this.bridgeContext.setDynamicState(2);
            } else {
                this.bridgeContext.setDynamicState(1);
            }
        }
        this.setBridgeContextAnimationLimitingMode();
        this.updateZoomAndPanEnable((Document)sVGDocument);
        this.nextGVTTreeBuilder = new GVTTreeBuilder(sVGDocument, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator iterator = this.gvtTreeBuilderListeners.iterator();
        while (iterator.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)iterator.next());
        }
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    protected void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String string) {
        this.fragmentIdentifier = string;
        if (this.computeRenderingTransform()) {
            this.scheduleGVTRendering();
        }
    }

    public void flushImageCache() {
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        imageTagRegistry.flushCache();
    }

    @Override
    public void setGraphicsNode(GraphicsNode graphicsNode, boolean bl) {
        Dimension2D dimension2D = this.bridgeContext.getDocumentSize();
        Dimension dimension = new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
        this.setMySize(dimension);
        SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
        this.prevComponentSize = this.getSize();
        AffineTransform affineTransform = this.calculateViewingTransform(this.fragmentIdentifier, sVGSVGElement);
        CanvasGraphicsNode canvasGraphicsNode = this.getCanvasGraphicsNode(graphicsNode);
        if (canvasGraphicsNode != null) {
            canvasGraphicsNode.setViewingTransform(affineTransform);
        }
        this.viewingTransform = null;
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform, false);
        this.jsvgComponentListener.updateMatrix(this.initialTransform);
        this.addJGVTComponentListener(this.jsvgComponentListener);
        this.addComponentListener(this.jsvgComponentListener);
        super.setGraphicsNode(graphicsNode, bl);
    }

    protected BridgeContext createBridgeContext(SVGOMDocument sVGOMDocument) {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        BridgeContext bridgeContext = sVGOMDocument.isSVG12() ? new SVG12BridgeContext(this.userAgent, this.loader) : new BridgeContext(this.userAgent, this.loader);
        return bridgeContext;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode graphicsNode) {
        UpdateManager updateManager = new UpdateManager(this.bridgeContext, graphicsNode, (Document)this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(graphicsNode, this.svgDocument, this.bridgeContext, updateManager);
        Iterator iterator = this.svgLoadEventDispatcherListeners.iterator();
        while (iterator.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)iterator.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    @Override
    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    public CanvasGraphicsNode getCanvasGraphicsNode() {
        return this.getCanvasGraphicsNode(this.gvtRoot);
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list.size() == 0) {
            return null;
        }
        graphicsNode = (GraphicsNode)list.get(0);
        if (!(graphicsNode instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AffineTransform getViewingTransform() {
        AffineTransform affineTransform;
        JSVGComponent jSVGComponent = this;
        synchronized (jSVGComponent) {
            CanvasGraphicsNode canvasGraphicsNode;
            affineTransform = this.viewingTransform;
            if (affineTransform == null && (canvasGraphicsNode = this.getCanvasGraphicsNode()) != null) {
                affineTransform = canvasGraphicsNode.getViewingTransform();
            }
        }
        return affineTransform;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform affineTransform = this.getRenderingTransform();
        affineTransform = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
        AffineTransform affineTransform2 = this.getViewingTransform();
        if (affineTransform2 != null) {
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }

    @Override
    protected boolean computeRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        boolean bl = this.updateRenderingTransform();
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.getRenderingTransform())) {
            this.setRenderingTransform(this.initialTransform, false);
            bl = true;
        }
        return bl;
    }

    protected AffineTransform calculateViewingTransform(String string, SVGSVGElement sVGSVGElement) {
        Dimension dimension = this.getSize();
        if (dimension.width < 1) {
            dimension.width = 1;
        }
        if (dimension.height < 1) {
            dimension.height = 1;
        }
        return ViewBox.getViewTransform(string, (Element)sVGSVGElement, dimension.width, dimension.height, this.bridgeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        try {
            AffineTransform affineTransform;
            AffineTransform affineTransform2;
            AffineTransform affineTransform3;
            SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.prevComponentSize;
            if (dimension2 == null) {
                dimension2 = dimension;
            }
            this.prevComponentSize = dimension;
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            if ((affineTransform3 = this.calculateViewingTransform(this.fragmentIdentifier, sVGSVGElement)).equals(affineTransform2 = this.getViewingTransform())) {
                return dimension2.width != dimension.width || dimension2.height != dimension.height;
            }
            if (!this.recenterOnResize) {
                return true;
            }
            Point2D point2D = new Point2D.Float((float)dimension2.width / 2.0f, (float)dimension2.height / 2.0f);
            AffineTransform affineTransform4 = this.getRenderingTransform();
            if (affineTransform4 != null) {
                try {
                    affineTransform = affineTransform4.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform2 != null) {
                try {
                    affineTransform = affineTransform2.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform3 != null) {
                point2D = affineTransform3.transform(point2D, null);
            }
            if (affineTransform4 != null) {
                point2D = affineTransform4.transform(point2D, null);
            }
            float f = (float)((double)((float)dimension.width / 2.0f) - point2D.getX());
            float f2 = (float)((double)((float)dimension.height / 2.0f) - point2D.getY());
            f = (int)(f < 0.0f ? (double)f - 0.5 : (double)f + 0.5);
            f2 = (int)(f2 < 0.0f ? (double)f2 - 0.5 : (double)f2 + 0.5);
            if (f != 0.0f || f2 != 0.0f) {
                affineTransform4.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
                this.setRenderingTransform(affineTransform4, false);
            }
            Object object = this;
            synchronized (object) {
                this.viewingTransform = affineTransform3;
            }
            object = new Runnable(){
                AffineTransform myAT;
                CanvasGraphicsNode myCGN;
                {
                    this.myAT = affineTransform3;
                    this.myCGN = JSVGComponent.this.getCanvasGraphicsNode();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JSVGComponent jSVGComponent = JSVGComponent.this;
                    synchronized (jSVGComponent) {
                        if (this.myCGN != null) {
                            this.myCGN.setViewingTransform(this.myAT);
                        }
                        if (JSVGComponent.this.viewingTransform == this.myAT) {
                            JSVGComponent.this.viewingTransform = null;
                        }
                    }
                }
            };
            UpdateManager updateManager = this.getUpdateManager();
            if (updateManager != null) {
                updateManager.getUpdateRunnableQueue().invokeLater((Runnable)object);
            } else {
                object.run();
            }
        }
        catch (BridgeException bridgeException) {
            this.userAgent.displayError(bridgeException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderGVTTree() {
        class UpdateRenderingRunnable
        implements Runnable {
            AffineTransform at;
            boolean doubleBuf;
            boolean clearPaintTrans;
            Shape aoi;
            int width;
            int height;
            boolean active;

            public UpdateRenderingRunnable(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
                this.updateInfo(affineTransform, bl, bl2, shape, n, n2);
                this.active = true;
            }

            public void updateInfo(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
                this.at = affineTransform;
                this.doubleBuf = bl;
                this.clearPaintTrans = bl2;
                this.aoi = shape;
                this.width = n;
                this.height = n2;
                this.active = true;
            }

            public void deactivate() {
                this.active = false;
            }

            @Override
            public void run() {
                if (!this.active) {
                    return;
                }
                JSVGComponent.this.updateManager.updateRendering(this.at, this.doubleBuf, this.clearPaintTrans, this.aoi, this.width, this.height);
            }
        }
        if (!this.isInteractiveDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        Rectangle rectangle = this.getRenderRect();
        if (this.gvtRoot == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        Shape shape = affineTransform == null ? rectangle : affineTransform.createTransformedShape(rectangle);
        RunnableQueue runnableQueue = this.updateManager.getUpdateRunnableQueue();
        Object object = runnableQueue.getIteratorLock();
        synchronized (object) {
            Iterator iterator = runnableQueue.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof UpdateRenderingRunnable)) continue;
                ((UpdateRenderingRunnable)e).deactivate();
            }
        }
        runnableQueue.invokeLater(new UpdateRenderingRunnable(this.renderingTransform, this.doubleBufferedRendering, true, shape, rectangle.width, rectangle.height));
    }

    @Override
    protected void handleException(Exception exception) {
        this.userAgent.displayError(exception);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.remove(sVGDocumentLoaderListener);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.remove(gVTTreeBuilderListener);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.add(sVGLoadEventDispatcherListener);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.remove(sVGLoadEventDispatcherListener);
    }

    public void addLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.add(linkActivationListener);
    }

    public void removeLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.remove(linkActivationListener);
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.remove(updateManagerListener);
    }

    public void showAlert(String string) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage(SCRIPT_ALERT, new Object[]{string}));
    }

    public String showPrompt(String string) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage(SCRIPT_PROMPT, new Object[]{string}));
    }

    public String showPrompt(String string, String string2) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage(SCRIPT_PROMPT, new Object[]{string}), null, -1, null, null, string2);
    }

    public boolean showConfirm(String string) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage(SCRIPT_CONFIRM, new Object[]{string}), "Confirm", 0) == 0;
    }

    public void setMySize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.invalidate();
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingCPU(float f) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingFPS(float f) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public Interpreter getInterpreter(String string) {
        if (this.bridgeContext != null) {
            return this.bridgeContext.getInterpreter(string);
        }
        return null;
    }

    protected void setBridgeContextAnimationLimitingMode() {
        switch (this.animationLimitingMode) {
            case 0: {
                this.bridgeContext.setAnimationLimitingNone();
                break;
            }
            case 1: {
                this.bridgeContext.setAnimationLimitingCPU(this.animationLimitingAmount);
                break;
            }
            case 2: {
                this.bridgeContext.setAnimationLimitingFPS(this.animationLimitingAmount);
            }
        }
    }

    @Override
    protected JGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    static {
        SVGFeatureStrings.addSupportedFeatureStrings(FEATURES);
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        @Override
        public Dimension2D getViewportSize() {
            return JSVGComponent.this.getSize();
        }

        @Override
        public EventDispatcher getEventDispatcher() {
            return JSVGComponent.this.eventDispatcher;
        }

        public void displayError(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(string);
            }
        }

        @Override
        public void displayError(Exception exception) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(exception);
            }
        }

        @Override
        public void displayMessage(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayMessage(string);
            }
        }

        @Override
        public void showAlert(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.showAlert(string);
                return;
            }
            JSVGComponent.this.showAlert(string);
        }

        @Override
        public String showPrompt(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(string);
            }
            return JSVGComponent.this.showPrompt(string);
        }

        @Override
        public String showPrompt(String string, String string2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showPrompt(string, string2);
            }
            return JSVGComponent.this.showPrompt(string, string2);
        }

        @Override
        public boolean showConfirm(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.showConfirm(string);
            }
            return JSVGComponent.this.showConfirm(string);
        }

        @Override
        public float getPixelUnitToMillimeter() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public String getDefaultFontFamily() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getDefaultFontFamily();
            }
            return "Arial, Helvetica, sans-serif";
        }

        @Override
        public float getMediumFontSize() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        @Override
        public float getLighterFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        @Override
        public float getBolderFontWeight(float f) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        @Override
        public String getLanguages() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        @Override
        public String getUserStyleSheetURI() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        @Override
        public void openLink(SVGAElement sVGAElement) {
            ParsedURL parsedURL;
            String string = XLinkSupport.getXLinkShow((Element)sVGAElement);
            String string2 = sVGAElement.getHref().getAnimVal();
            if (string.equals("new")) {
                this.fireLinkActivatedEvent(sVGAElement, string2);
                if (JSVGComponent.this.svgUserAgent != null) {
                    String string3 = JSVGComponent.this.svgDocument.getURL();
                    ParsedURL parsedURL2 = null;
                    if (sVGAElement.getOwnerDocument() != JSVGComponent.this.svgDocument) {
                        SVGDocument sVGDocument = (SVGDocument)sVGAElement.getOwnerDocument();
                        string2 = new ParsedURL(sVGDocument.getURL(), string2).toString();
                    }
                    parsedURL2 = new ParsedURL(string3, string2);
                    string2 = parsedURL2.toString();
                    JSVGComponent.this.svgUserAgent.openLink(string2, true);
                } else {
                    JSVGComponent.this.loadSVGDocument(string2);
                }
                return;
            }
            ParsedURL parsedURL3 = new ParsedURL(((SVGDocument)sVGAElement.getOwnerDocument()).getURL(), string2);
            string2 = parsedURL3.toString();
            if (JSVGComponent.this.svgDocument != null && parsedURL3.sameFile(parsedURL = new ParsedURL(JSVGComponent.this.svgDocument.getURL()))) {
                String string4 = parsedURL3.getRef();
                if (!(JSVGComponent.this.fragmentIdentifier == string4 || string4 != null && string4.equals(JSVGComponent.this.fragmentIdentifier))) {
                    JSVGComponent.this.fragmentIdentifier = string4;
                    if (JSVGComponent.this.computeRenderingTransform()) {
                        JSVGComponent.this.scheduleGVTRendering();
                    }
                }
                this.fireLinkActivatedEvent(sVGAElement, string2);
                return;
            }
            this.fireLinkActivatedEvent(sVGAElement, string2);
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.openLink(string2, false);
            } else {
                JSVGComponent.this.loadSVGDocument(string2);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement sVGAElement, String string) {
            Object[] objectArray = JSVGComponent.this.linkActivationListeners.toArray();
            if (objectArray.length > 0) {
                LinkActivationEvent linkActivationEvent = new LinkActivationEvent(JSVGComponent.this, sVGAElement, string);
                for (int i = 0; i < objectArray.length; ++i) {
                    LinkActivationListener linkActivationListener = (LinkActivationListener)objectArray[i];
                    linkActivationListener.linkActivated(linkActivationEvent);
                }
            }
        }

        @Override
        public void setSVGCursor(Cursor cursor) {
            if (cursor != JSVGComponent.this.getCursor()) {
                JSVGComponent.this.setCursor(cursor);
            }
        }

        @Override
        public void setTextSelection(Mark mark, Mark mark2) {
            JSVGComponent.this.select(mark, mark2);
        }

        @Override
        public void deselectAll() {
            JSVGComponent.this.deselectAll();
        }

        @Override
        public String getXMLParserClassName() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        @Override
        public boolean isXMLParserValidating() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        @Override
        public AffineTransform getTransform() {
            return JSVGComponent.this.renderingTransform;
        }

        @Override
        public void setTransform(AffineTransform affineTransform) {
            JSVGComponent.this.setRenderingTransform(affineTransform);
        }

        @Override
        public String getMedia() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        @Override
        public String getAlternateStyleSheet() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        @Override
        public Point getClientAreaLocationOnScreen() {
            return JSVGComponent.this.getLocationOnScreen();
        }

        @Override
        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        @Override
        public boolean supportExtension(String string) {
            if (JSVGComponent.this.svgUserAgent != null && JSVGComponent.this.svgUserAgent.supportExtension(string)) {
                return true;
            }
            return this.extensions.containsKey(string);
        }

        @Override
        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.put(iterator.next(), bridgeExtension);
            }
        }

        @Override
        public void handleElement(Element element, Object object) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.handleElement(element, object);
            }
        }

        @Override
        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
        }

        @Override
        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
                if (scriptSecurity != null) {
                    scriptSecurity.checkLoadScript();
                }
            }
        }

        @Override
        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
        }

        @Override
        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
                if (externalResourceSecurity != null) {
                    externalResourceSecurity.checkLoadExternalResource();
                }
            }
        }

        @Override
        public SVGDocument getBrokenLinkDocument(Element element, String string, String string2) {
            Class<JSVGComponent> clazz = JSVGComponent.class;
            URL uRL = clazz.getResource("resources/BrokenLink.svg");
            if (uRL == null) {
                throw new BridgeException(JSVGComponent.this.bridgeContext, element, "uri.image.broken", new Object[]{string, string2});
            }
            DocumentLoader documentLoader = JSVGComponent.this.bridgeContext.getDocumentLoader();
            SVGDocument sVGDocument = null;
            try {
                sVGDocument = (SVGDocument)documentLoader.loadDocument(uRL.toString());
                if (sVGDocument == null) {
                    return sVGDocument;
                }
                DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
                Element element2 = (sVGDocument = (SVGDocument)DOMUtilities.deepCloneDocument((Document)sVGDocument, dOMImplementation)).getElementById("__More_About");
                if (element2 == null) {
                    return sVGDocument;
                }
                Element element3 = sVGDocument.createElementNS("http://www.w3.org/2000/svg", "title");
                String string3 = Messages.formatMessage(JSVGComponent.BROKEN_LINK_TITLE, null);
                element3.appendChild(sVGDocument.createTextNode(string3));
                Element element4 = sVGDocument.createElementNS("http://www.w3.org/2000/svg", "desc");
                element4.appendChild(sVGDocument.createTextNode(string2));
                element2.insertBefore(element4, element2.getFirstChild());
                element2.insertBefore(element3, element4);
            }
            catch (Exception exception) {
                throw new BridgeException(JSVGComponent.this.bridgeContext, element, exception, "uri.image.broken", new Object[]{string, string2});
            }
            return sVGDocument;
        }

        @Override
        public void loadDocument(String string) {
            JSVGComponent.this.loadSVGDocument(string);
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getEventDispatcher();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getViewportSize();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void displayError(final Exception exception) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(exception);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.displayError(exception);
                    }
                });
            }
        }

        @Override
        public void displayMessage(final String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(string);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.displayMessage(string);
                    }
                });
            }
        }

        @Override
        public void showAlert(final String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(string);
            } else {
                this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.showAlert(string);
                    }
                });
            }
        }

        @Override
        public String showPrompt(final String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string);
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showPrompt(string);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public String showPrompt(final String string, final String string2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string, string2);
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showPrompt(string, string2);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public boolean showConfirm(final String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(string);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.showConfirm(string);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public String getDefaultFontFamily() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getDefaultFontFamily();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getDefaultFontFamily();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getMediumFontSize();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            final float f2 = f;
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getLighterFontWeight(f2);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            final float f2 = f;
            class Query
            implements Runnable {
                float result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getBolderFontWeight(f2);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getLanguages();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getUserStyleSheetURI();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void openLink(final SVGAElement sVGAElement) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(sVGAElement);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.openLink(sVGAElement);
                    }
                });
            }
        }

        @Override
        public void setSVGCursor(final Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setSVGCursor(cursor);
                    }
                });
            }
        }

        @Override
        public void setTextSelection(final Mark mark, final Mark mark2) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTextSelection(mark, mark2);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setTextSelection(mark, mark2);
                    }
                });
            }
        }

        @Override
        public void deselectAll() {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.deselectAll();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.deselectAll();
                    }
                });
            }
        }

        @Override
        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getXMLParserClassName();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.isXMLParserValidating();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getTransform();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void setTransform(AffineTransform affineTransform) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTransform(affineTransform);
            } else {
                final AffineTransform affineTransform2 = affineTransform;
                class Query
                implements Runnable {
                    Query() {
                    }

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.setTransform(affineTransform2);
                    }
                }
                Query query = new Query();
                this.invokeAndWait(query);
            }
        }

        @Override
        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getMedia();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getAlternateStyleSheet();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public boolean hasFeature(final String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(string);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.hasFeature(string);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public boolean supportExtension(final String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(string);
            }
            class Query
            implements Runnable {
                boolean result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.supportExtension(string);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void registerExtension(final BridgeExtension bridgeExtension) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(bridgeExtension);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.registerExtension(bridgeExtension);
                    }
                });
            }
        }

        @Override
        public void handleElement(final Element element, final Object object) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(element, object);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BridgeUserAgentWrapper.this.userAgent.handleElement(element, object);
                    }
                });
            }
        }

        @Override
        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            final String string2 = string;
            final ParsedURL parsedURL3 = parsedURL;
            final ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ScriptSecurity result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getScriptSecurity(string2, parsedURL3, parsedURL4);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                final String string2 = string;
                final ParsedURL parsedURL3 = parsedURL;
                final ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se = null;

                    Query() {
                    }

                    @Override
                    public void run() {
                        try {
                            BridgeUserAgentWrapper.this.userAgent.checkLoadScript(string2, parsedURL3, parsedURL4);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query();
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        @Override
        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            final ParsedURL parsedURL3 = parsedURL;
            final ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;

                Query() {
                }

                @Override
                public void run() {
                    this.result = BridgeUserAgentWrapper.this.userAgent.getExternalResourceSecurity(parsedURL3, parsedURL4);
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            return query.result;
        }

        @Override
        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                final ParsedURL parsedURL3 = parsedURL;
                final ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se;

                    Query() {
                    }

                    @Override
                    public void run() {
                        try {
                            BridgeUserAgentWrapper.this.userAgent.checkLoadExternalResource(parsedURL3, parsedURL4);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query();
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        @Override
        public SVGDocument getBrokenLinkDocument(final Element element, final String string, final String string2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBrokenLinkDocument(element, string, string2);
            }
            class Query
            implements Runnable {
                SVGDocument doc;
                RuntimeException rex = null;

                Query() {
                }

                @Override
                public void run() {
                    try {
                        this.doc = BridgeUserAgentWrapper.this.userAgent.getBrokenLinkDocument(element, string, string2);
                    }
                    catch (RuntimeException runtimeException) {
                        this.rex = runtimeException;
                    }
                }
            }
            Query query = new Query();
            this.invokeAndWait(query);
            if (query.rex != null) {
                throw query.rex;
            }
            return query.doc;
        }

        protected void invokeAndWait(Runnable runnable) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void loadDocument(String string) {
            this.userAgent.loadDocument(string);
        }
    }

    protected class SVGListener
    extends JGVTComponent.Listener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
        }

        @Override
        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        }

        @Override
        public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            JSVGComponent.this.setSVGDocument(sVGDocumentLoaderEvent.getSVGDocument());
        }

        @Override
        public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        @Override
        public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)sVGDocumentLoaderEvent.getSource()).getException());
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        @Override
        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            JSVGComponent.this.removeJGVTComponentListener(JSVGComponent.this.jsvgComponentListener);
            JSVGComponent.this.removeComponentListener(JSVGComponent.this.jsvgComponentListener);
        }

        @Override
        public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.gvtRoot = null;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.eventsEnabled) {
                JSVGComponent.this.startSVGLoadEventDispatcher(gVTTreeBuilderEvent.getGVTRoot());
            } else {
                if (JSVGComponent.this.isInteractiveDocument) {
                    JSVGComponent.this.nextUpdateManager = new UpdateManager(JSVGComponent.this.bridgeContext, gVTTreeBuilderEvent.getGVTRoot(), (Document)JSVGComponent.this.svgDocument);
                }
                JSVGComponent.this.setGraphicsNode(gVTTreeBuilderEvent.getGVTRoot(), false);
                JSVGComponent.this.scheduleGVTRendering();
            }
        }

        @Override
        public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.image = null;
            JSVGComponent.this.repaint();
        }

        @Override
        public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = gVTTreeBuilderEvent.getGVTRoot();
            if (graphicsNode == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.this.setGraphicsNode(graphicsNode, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)gVTTreeBuilderEvent.getSource()).getException());
        }

        @Override
        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        }

        @Override
        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.nextUpdateManager.interrupt();
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.setGraphicsNode(sVGLoadEventDispatcherEvent.getGVTRoot(), false);
            JSVGComponent.this.scheduleGVTRendering();
        }

        @Override
        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        @Override
        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            JSVGComponent.this.nextUpdateManager = JSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            JSVGComponent.this.svgLoadEventDispatcher = null;
            JSVGComponent.this.nextUpdateManager.interrupt();
            JSVGComponent.this.nextUpdateManager = null;
            if (JSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = sVGLoadEventDispatcherEvent.getGVTRoot();
            if (graphicsNode == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.this.setGraphicsNode(graphicsNode, false);
                JSVGComponent.this.computeRenderingTransform();
            }
            JSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)sVGLoadEventDispatcherEvent.getSource()).getException());
        }

        @Override
        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCompleted(gVTTreeRendererEvent);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.nextUpdateManager != null) {
                JSVGComponent.this.updateManager = JSVGComponent.this.nextUpdateManager;
                JSVGComponent.this.nextUpdateManager = null;
                JSVGComponent.this.updateManager.addUpdateManagerListener(this);
                JSVGComponent.this.updateManager.manageUpdates(JSVGComponent.this.renderer);
            }
        }

        @Override
        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCancelled(gVTTreeRendererEvent);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        @Override
        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingFailed(gVTTreeRendererEvent);
            if (JSVGComponent.this.afterStopRunnable != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                JSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                if (JSVGComponent.this.nextUpdateManager != null) {
                    JSVGComponent.this.nextUpdateManager.interrupt();
                    JSVGComponent.this.nextUpdateManager = null;
                }
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        @Override
        public void managerStarted(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSVGComponent.this.suspendInteractions = false;
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerStarted(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        public void managerSuspended(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerSuspended(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        public void managerResumed(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerResumed(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        public void managerStopped(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSVGComponent.this.updateManager = null;
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerStopped(updateManagerEvent);
                        }
                    }
                    if (JSVGComponent.this.afterStopRunnable != null) {
                        EventQueue.invokeLater(JSVGComponent.this.afterStopRunnable);
                        JSVGComponent.this.afterStopRunnable = null;
                        return;
                    }
                    if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                        JSVGComponent.this.startGVTTreeBuilder();
                        return;
                    }
                    if (JSVGComponent.this.nextDocumentLoader != null) {
                        JSVGComponent.this.startDocumentLoader();
                        return;
                    }
                }
            });
        }

        @Override
        public void updateStarted(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray;
                    if (!JSVGComponent.this.doubleBufferedRendering) {
                        JSVGComponent.this.image = updateManagerEvent.getImage();
                    }
                    if ((objectArray = JSVGComponent.this.updateManagerListeners.toArray()).length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateStarted(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        public void updateCompleted(final UpdateManagerEvent updateManagerEvent) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        List list;
                        JSVGComponent.this.image = updateManagerEvent.getImage();
                        if (updateManagerEvent.getClearPaintingTransform()) {
                            JSVGComponent.this.paintingTransform = null;
                        }
                        if ((list = updateManagerEvent.getDirtyAreas()) != null) {
                            for (Rectangle rectangle : list) {
                                if (JSVGComponent.this.updateOverlay != null) {
                                    JSVGComponent.this.updateOverlay.addRect(rectangle);
                                    rectangle = JSVGComponent.this.getRenderRect();
                                }
                                if (JSVGComponent.this.doubleBufferedRendering) {
                                    JSVGComponent.this.repaint(rectangle);
                                    continue;
                                }
                                JSVGComponent.this.paintImmediately(rectangle);
                            }
                            if (JSVGComponent.this.updateOverlay != null) {
                                JSVGComponent.this.updateOverlay.endUpdate();
                            }
                        }
                        JSVGComponent.this.suspendInteractions = false;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateCompleted(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        public void updateFailed(final UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = JSVGComponent.this.updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateFailed(updateManagerEvent);
                        }
                    }
                }
            });
        }

        @Override
        protected void dispatchKeyTyped(final KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyTyped(keyEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchKeyPressed(final KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyPressed(keyEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchKeyReleased(final KeyEvent keyEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(keyEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.keyReleased(keyEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseClicked(final MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseClicked(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseClicked(mouseEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchMousePressed(final MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mousePressed(mouseEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseReleased(final MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseReleased(mouseEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseEntered(final MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseEntered(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseEntered(mouseEvent);
                    }
                });
            }
        }

        @Override
        protected void dispatchMouseExited(final MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseExited(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseExited(mouseEvent);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchMouseDragged(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;

                    MouseDraggedRunnable(MouseEvent mouseEvent) {
                        this.event = mouseEvent;
                    }

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseDragged(this.event);
                    }
                }
                RunnableQueue runnableQueue = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mouseDraggedRunnable = (MouseDraggedRunnable)e;
                        MouseEvent mouseEvent2 = mouseDraggedRunnable.event;
                        if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                            mouseDraggedRunnable.event = mouseEvent;
                        }
                        return;
                    }
                }
                runnableQueue.invokeLater(new MouseDraggedRunnable(mouseEvent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatchMouseMoved(MouseEvent mouseEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseMoved(mouseEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;

                    MouseMovedRunnable(MouseEvent mouseEvent) {
                        this.event = mouseEvent;
                    }

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseMoved(this.event);
                    }
                }
                RunnableQueue runnableQueue = JSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int n = 0;
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mouseMovedRunnable = (MouseMovedRunnable)e;
                            MouseEvent mouseEvent2 = mouseMovedRunnable.event;
                            if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                                mouseMovedRunnable.event = mouseEvent;
                            }
                            return;
                        }
                        ++n;
                    }
                }
                runnableQueue.invokeLater(new MouseMovedRunnable(mouseEvent));
            }
        }

        @Override
        protected void dispatchMouseWheelMoved(final MouseWheelEvent mouseWheelEvent) {
            if (!JSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseWheelMoved(mouseWheelEvent);
                return;
            }
            if (JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSVGComponent.this.eventDispatcher.mouseWheelMoved(mouseWheelEvent);
                    }
                });
            }
        }
    }

    protected class JSVGComponentListener
    extends ComponentAdapter
    implements JGVTComponentListener {
        float prevScale = 0.0f;
        float prevTransX = 0.0f;
        float prevTransY = 0.0f;

        protected JSVGComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSVGComponent.this.updateManager.dispatchSVGResizeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        @Override
        public void componentTransformChanged(ComponentEvent componentEvent) {
            boolean bl;
            AffineTransform affineTransform = JSVGComponent.this.getRenderingTransform();
            float f = (float)Math.sqrt(affineTransform.getDeterminant());
            float f2 = (float)affineTransform.getTranslateX();
            float f3 = (float)affineTransform.getTranslateY();
            final boolean bl2 = f != this.prevScale;
            boolean bl3 = bl = f2 != this.prevTransX || f3 != this.prevTransY;
            if (JSVGComponent.this.isDynamicDocument && JSVGComponent.this.updateManager != null && JSVGComponent.this.updateManager.isRunning()) {
                JSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (bl2) {
                                JSVGComponent.this.updateManager.dispatchSVGZoomEvent();
                            }
                            if (bl) {
                                JSVGComponent.this.updateManager.dispatchSVGScrollEvent();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.prevScale = f;
            this.prevTransX = f2;
            this.prevTransY = f3;
        }

        public void updateMatrix(AffineTransform affineTransform) {
            this.prevScale = (float)Math.sqrt(affineTransform.getDeterminant());
            this.prevTransX = (float)affineTransform.getTranslateX();
            this.prevTransY = (float)affineTransform.getTranslateY();
        }
    }
}

