/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.thesaurus.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.loadors.RootThesaurusNodeLoadors;
import org.chorem.vradi.ui.thesaurus.loadors.ThesaurusNodeLoadors;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.chorem.vradi.ui.tree.helpers.VradiTreeHelper;

public class ThesaurusTreeHelper
extends VradiTreeHelper<Thesaurus> {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    protected RootThesaurus rootThesaurus;
    protected Thesaurus thesaurus;
    protected boolean listening = true;
    protected VradiEntitiesListener<RootThesaurus> thesaurusVradiEntitiesListener;

    public ThesaurusTreeHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, RootThesaurus rootThesaurus) {
        this.rootThesaurus = rootThesaurus;
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, Thesaurus thesaurus) {
        this.thesaurus = thesaurus;
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Thesaurus.class, this);
        this.thesaurusVradiEntitiesListener = new VradiEntitiesListener<RootThesaurus>(){

            @Override
            public void entitiesAdded(Set<RootThesaurus> added) {
                if (ThesaurusTreeHelper.this.rootThesaurus == null && ThesaurusTreeHelper.this.thesaurus == null) {
                    for (RootThesaurus rootThesaurus : added) {
                        String wikittyId = rootThesaurus.getWikittyId();
                        VradiTreeNode existingNode = ThesaurusTreeHelper.this.findRootThesaurusNode(wikittyId);
                        if (existingNode != null) {
                            ThesaurusTreeHelper.this.refresh(existingNode);
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Refresh root thesaurus : " + wikittyId));
                        }
                        VradiTreeNode newNode = ((RootThesaurusNodeLoadors)NavHelper.getChildLoador(RootThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeHelper.this.getDataProvider());
                        ThesaurusTreeHelper.this.insertNode((NavNode)ThesaurusTreeHelper.this.getRootNode(), (NavNode)newNode);
                    }
                } else if (ThesaurusTreeHelper.this.rootThesaurus != null && added.contains(ThesaurusTreeHelper.this.rootThesaurus)) {
                    ThesaurusTreeHelper.this.refresh(ThesaurusTreeHelper.this.getRootNode());
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(RootThesaurus.class, this.thesaurusVradiEntitiesListener);
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root;
        if (this.thesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] thesaurus " + this.thesaurus.getName()));
            }
            root = new VradiTreeNode(Thesaurus.class, this.thesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else if (this.rootThesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] root thesaurus " + this.rootThesaurus.getName()));
            }
            root = new VradiTreeNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Root creation] all root thesaurus");
            }
            root = new VradiTreeNode(String.class, "Root node", null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(RootThesaurusNodeLoadors.class));
        }
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        this.registerLoadedIds(root);
        return model;
    }

    public void tryToSelect(String id) {
        Thesaurus thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
        this.tryToSelect(thesaurus);
    }

    public void tryToSelect(Thesaurus thesaurus) {
        VradiTreeNode nodeFound;
        if (!thesaurus.getWikittyId().equals(this.getRootNode().getId()) && (nodeFound = this.findThesaurusNode(thesaurus)) != null) {
            this.selectNode(nodeFound);
        }
    }

    public void tryToSelect(List<String> thesaurusIds) {
        this.tryToSelect((Collection<Thesaurus>)ThesaurusDataHelper.restoreThesaurus(thesaurusIds));
    }

    public void tryToSelect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(this.getRootNode().getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(String id) {
        this.tryToUnselect(ThesaurusDataHelper.restoreThesaurus(id));
    }

    public void tryToUnselect(Thesaurus thesaurus) {
        this.tryToUnselect(thesaurus.getWikittyId());
        VradiTreeNode nodeFound = this.findThesaurusNode(thesaurus);
        if (nodeFound != null) {
            this.unSelectNode((NavNode)nodeFound);
        }
    }

    public void tryToUnselect(List<String> thesaurusIds) {
        this.tryToUnselect((Collection<Thesaurus>)ThesaurusDataHelper.restoreThesaurus(thesaurusIds));
    }

    public void tryToUnselect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(this.getRootNode().getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.unSelectNodes(nodes);
    }

    public VradiTreeNode findRootThesaurusNode(String rootThesaurusId) {
        VradiTreeNode parentNode = this.getRootNode();
        return (VradiTreeNode)this.getChild((NavNode)parentNode, rootThesaurusId);
    }

    public VradiTreeNode findRootThesaurusNode(RootThesaurus rootThesaurus) {
        return this.findRootThesaurusNode(rootThesaurus.getWikittyId());
    }

    protected VradiTreeNode findThesaurusNode(String thesaurusId) {
        return this.findThesaurusNode(ThesaurusDataHelper.restoreThesaurus(thesaurusId));
    }

    protected VradiTreeNode findThesaurusNode(Thesaurus thesaurus) {
        VradiTreeNode parentNode = this.getRootNode();
        VradiTreeNode rootNode = (VradiTreeNode)this.getChild((NavNode)parentNode, thesaurus.getRootThesaurus());
        if (rootNode != null) {
            parentNode = rootNode;
        }
        List<Thesaurus> parentList = this.getParentsPathThesaurus(thesaurus);
        for (Thesaurus parent : parentList) {
            VradiTreeNode nodeFound = (VradiTreeNode)this.getChild((NavNode)parentNode, parent.getWikittyId());
            if (nodeFound == null) continue;
            parentNode = nodeFound;
        }
        if (!parentNode.getId().equals(thesaurus.getWikittyId())) {
            return null;
        }
        return parentNode;
    }

    protected List<Thesaurus> getParentsPathThesaurus(Thesaurus thesaurus) {
        Thesaurus parent;
        ArrayList<Thesaurus> parents = new ArrayList<Thesaurus>();
        if (!ThesaurusDataHelper.isFirstChild(thesaurus) && (parent = ThesaurusDataHelper.restoreThesaurus(thesaurus.getParent())) != null) {
            List<Thesaurus> thesauruses = this.getParentsPathThesaurus(parent);
            parents.addAll(thesauruses);
        }
        parents.add(thesaurus);
        return parents;
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                if (bean == null) continue;
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    @Override
    public void createEntityNode(String wikittyId) {
    }

    @Override
    public void entitiesAdded(Set<Thesaurus> added) {
        for (Thesaurus thesaurusConcerned : added) {
            String wikittyId = thesaurusConcerned.getWikittyId();
            if (!this.idsLoaded.contains(thesaurusConcerned.getParent())) continue;
            VradiTreeNode existingNode = this.findThesaurusNode(wikittyId);
            if (existingNode != null) {
                VradiTreeNode parent = (VradiTreeNode)existingNode.getParent();
                String newParentId = thesaurusConcerned.getParent();
                if (parent != null && !parent.getId().equals(newParentId)) {
                    VradiTreeNode newParentNode = this.findThesaurusNode(newParentId);
                    ((NavTreeBridge)this.getBridge()).removeNodeFromParent((NavTreeNode)existingNode);
                    if (this.findThesaurusNode(wikittyId) != null) continue;
                    this.insertNode((NavNode)newParentNode, (NavNode)existingNode);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                }
                this.refresh(existingNode);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
            }
            VradiTreeNode parentNode = this.findThesaurusNode(thesaurusConcerned.getParent());
            VradiTreeNode newNode = ((ThesaurusNodeLoadors)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
            if (this.findThesaurusNode(wikittyId) != null) continue;
            this.insertNode((NavNode)parentNode, (NavNode)newNode);
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        for (String wikittyId : removed) {
            if (!this.isLoadedId(wikittyId)) continue;
            VradiTreeNode node = this.findThesaurusNode(wikittyId);
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)node));
            node.removeFromParent();
            ((NavTreeBridge)this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeNode[]{node});
        }
    }
}

