/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.email.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupForms;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

public class EmailFormsListCellRenderer
extends DefaultListCellRenderer {
    private static final Log log = LogFactory.getLog(EmailFormsListCellRenderer.class);
    protected Session sessionConcerned;
    protected String formConcerned;
    protected List<Object> cachedDeletion = new ArrayList<Object>();
    protected Map<String, String> cachedRendered = new HashMap<String, String>();
    protected Map<String, Boolean> cachedAdded = new HashMap<String, Boolean>();

    public void updateDatas(Session sessionConcerned, String formConcerned) {
        this.sessionConcerned = sessionConcerned;
        this.formConcerned = formConcerned;
        this.clearCaches();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        String wikittyId = ((BusinessEntity)value).getWikittyId();
        String renderedText = this.cachedRendered.get(wikittyId);
        if (renderedText != null) {
            Component rendered = super.getListCellRendererComponent((JList<?>)list, renderedText, index, isSelected, cellHasFocus);
            Boolean added = this.cachedAdded.get(wikittyId);
            if (added != null && added.booleanValue()) {
                rendered.setForeground(Color.BLUE);
            }
            return rendered;
        }
        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        boolean isAdded = false;
        if (value instanceof User) {
            User user = (User)value;
            String clientId = user.getClient();
            Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, clientId);
            String clientString = "";
            if (client != null) {
                clientString = client.getName() + " - ";
            }
            renderedText = clientString + user.getName();
            Sending sending = EmailDataHelper.getUserSending(this.sessionConcerned, user);
            if (sending != null) {
                Set addedForms;
                Set deletedForms = SendingHelper.extractForms((WikittyProxy)wikittyProxy, (Collection)sending.getDeletedGroupForms());
                if (deletedForms != null && deletedForms.contains(this.formConcerned)) {
                    this.cachedDeletion.add(value);
                    renderedText = UIHelper.crossOf(renderedText);
                }
                if ((addedForms = SendingHelper.extractForms((WikittyProxy)wikittyProxy, (Collection)sending.getAddedGroupForms())) != null && addedForms.contains(this.formConcerned)) {
                    isAdded = true;
                }
            }
        } else if (value instanceof Group) {
            Group group = (Group)value;
            renderedText = group.getName();
            Set userIds = group.getUser();
            if (userIds != null) {
                int deletedCount = 0;
                List<Sending> sendings = EmailDataHelper.getUsersSendings(this.sessionConcerned, userIds);
                block0: for (Sending sending : sendings) {
                    Set groupFormsAddedIds;
                    if (sending == null) continue;
                    Set groupFormsDeletedIds = sending.getDeletedGroupForms();
                    if (groupFormsDeletedIds != null) {
                        List groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList(groupFormsDeletedIds));
                        for (GroupForms groupForm : groupForms) {
                            if (groupForm.getForm() == null || !groupForm.getForm().contains(this.formConcerned)) continue;
                            ++deletedCount;
                            break;
                        }
                    }
                    if ((groupFormsAddedIds = sending.getAddedGroupForms()) == null) continue;
                    List groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList(groupFormsAddedIds));
                    for (GroupForms groupForm : groupForms) {
                        String groupId = groupForm.getGroup();
                        if (groupId == null || !groupId.equals(group.getWikittyId()) || groupForm.getForm() == null || !groupForm.getForm().contains(this.formConcerned)) continue;
                        isAdded = true;
                        continue block0;
                    }
                }
                if (deletedCount == sendings.size()) {
                    this.cachedDeletion.add(value);
                    renderedText = UIHelper.crossOf(renderedText);
                }
            }
        }
        this.cachedRendered.put(wikittyId, renderedText);
        this.cachedAdded.put(wikittyId, isAdded);
        Component rendered = super.getListCellRendererComponent((JList<?>)list, renderedText, index, isSelected, cellHasFocus);
        if (isAdded) {
            rendered.setForeground(Color.BLUE);
        }
        return rendered;
    }

    public boolean isDeleted(Object o) {
        return this.cachedDeletion.contains(o);
    }

    public boolean areDeleted(Object[] o) {
        return this.cachedDeletion.containsAll(Arrays.asList(o));
    }

    public void clearCaches() {
        this.cachedDeletion.clear();
        this.cachedRendered.clear();
        this.cachedAdded.clear();
    }
}

