/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.renderers;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.i18n.I18n;

public class AdminCellRenderer
extends AbstractNavTreeCellRenderer<DefaultTreeModel, VradiTreeNode> {
    private static final long serialVersionUID = 7917305304778635796L;
    protected static final Log log = LogFactory.getLog(AdminCellRenderer.class);
    protected DecoratorProvider decoratorProvider;

    public AdminCellRenderer(DecoratorProvider decoratorProvider, VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        this.decoratorProvider = decoratorProvider;
    }

    public String getNodeText(VradiTreeNode node) {
        String text;
        if (node == null) {
            return null;
        }
        if (node.isDirty() || !this.renderCache.containsKey((Object)node)) {
            String id;
            text = node.isStringNode() ? ((id = node.getId()).matches(".+" + AdminBeanConstant.USER.getCategoryName()) ? I18n._((String)AdminBeanConstant.USER.getCategoryName(), (Object[])new Object[0]) : I18n._((String)id, (Object[])new Object[0])) : this.computeNodeText(node);
            if (log.isDebugEnabled()) {
                log.debug((Object)("text for node [" + (Object)((Object)node) + "] = <" + text + ">"));
            }
            this.renderCache.put(node, text);
            node.setDirty(false);
        } else {
            text = (String)this.renderCache.get((Object)node);
        }
        return text;
    }

    protected String computeNodeText(VradiTreeNode node) {
        VradiTreeNode clientCategoryNode;
        Class editType = node.getInternalClass();
        String id = node.getId();
        Decorator decorator = this.decoratorProvider.getDecorator(editType);
        if (editType.equals(User.class) && (clientCategoryNode = AdminNavigationTreeHelper.getParentCategoryNode(node, AdminBeanConstant.CLIENT.getCategoryName())) != null) {
            decorator = this.decoratorProvider.getDecorator(User.class, "userOnly");
        }
        Object toDecorate = AdminBeanConstant.getConstantByBeanClass(editType).getBean(((VradiDataProvider)this.getDataProvider()).getWikittyProxy(), id);
        String decorated = decorator.toString(toDecorate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compute text for node " + (Object)((Object)node) + " return " + decorated));
        }
        return decorated;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        VradiTreeNode node = (VradiTreeNode)((Object)value);
        String text = this.getNodeText(node);
        return super.getTreeCellRendererComponent(tree, (Object)text, sel, expanded, leaf, row, hasFocus);
    }
}

