/*
 * #%L
 * Vradi :: Swing
 * *
 * $Id: ThesaurusTreeTableModel.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/thesaurus/models/ThesaurusTreeTableModel.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.thesaurus.models;

import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.thesaurus.ThesaurusDataProvider;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;

import static org.nuiton.i18n.I18n._;

/** @author sletellier */
public class ThesaurusTreeTableModel extends NavTreeTableModel.MyDefaultTreeTableModel {

    private static final Log log = LogFactory.getLog(ThesaurusTreeTableModel.class);

    protected ThesaurusDataProvider dataProvider;

    public ThesaurusTreeTableModel(ThesaurusDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public Object getValueAt(Object value, int column) {
        Object result;
        VradiTreeTableNode node = (VradiTreeTableNode) value;

        RootThesaurus rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus(node);
        if (rootThesaurus != null) {
            result = getValueForRootThesaurus(rootThesaurus, column);
        } else {
            Thesaurus thesaurus = ThesaurusTreeTableHelper.getThesaurus(node);
            result = getValueForThesaurus(thesaurus, column);
        }

        return result;
    }


    @Override
    public String[] getColumnsNames() {
        return new String[]{_("vradi.thesaurus.colomns.name"),
                            _("vradi.thesaurus.colomns.nbForm"),
                            _("vradi.thesaurus.colomns.tags")};
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    protected Object getValueForRootThesaurus(RootThesaurus rootThesaurus, int column) {
        if (rootThesaurus == null) {
            return "not found";
        }

        if (column == 0) {
            return rootThesaurus;
        }
        return "";
    }

    protected Object getValueForThesaurus(Thesaurus thesaurus, int column) {
        if (thesaurus == null) {
            return "not found";
        }

        Object result = null;
        switch (column) {
            case 0:
                result = thesaurus;
                break;
            case 1:
                result = String.valueOf(dataProvider.getNbFormsForThesaurus(thesaurus));
                break;
            case 2:
                result = ThesaurusDataHelper.getTagsAsString(thesaurus);
                break;
        }
        return result;
    }
}
