/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VradiTabHeader extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ID = "id";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz08TQRSeVtpSfihQrBgxqUCMF7cmXkxABDEESVFCiSH24uzutB2y3RlmZmHlYPwT/BP07sXEmyfjwbMHL8Z/wRgPXo1vtr+orO3GtYfd7rz3vvne976Z199QSgp0ZR/7viE8V9EGMTZX9/YemvvEUveItATlignU/CWSKFlBo3ZnXSo0Xynp8mKrvLjGGpy5xD1RvVhCI1I9dYisE6IUutxbYUlZLHfCiz73RBu1QyoM9eWP78kX9vNXSYR8Dux0K4VBVd1OhkooSW2FpmCnQ1x0sFsDGoK6NeA7rtfWHCzlA9wgB+gZypRQmmMBYArNRW85wAjqfa5QZmEXmw65odA1JmqGVWeCNIxDgW1qeNRg1SoRxiP9CXkbBNtEcB6Up1WT7YQmZmiyRpNsN55ysEkcaEin+IY8gqixWdKLOiPbSczaRGGrDlsolOtJvuspxdze7GHLYZJAsv6ebsUEutSjNMzQ6M6wK3KiglLCg2WFZiqnx74DoebAZ/4YuAYMor/yuc/vvr5db0/5Aux9PjT1hElBfS4YJ0JRvfW55og9RZ3iFuaLFZSVxAGHBw6eDSFWboWBHOw3GYiuy40NLOsAkcp8ef8h/+TTGZRcRyMOw/Y61vn3UVbVBajAHNvnd1YCRmNHw/Cc0NwUSjOODzzQaGqJug51SQErGKTpKbLsgxCzIUJ02JjZjz9z5TcrbTESQO7iX9O7gqQeo3Rzt8D0LT+HmnyUS+LZrOvbMCcn9HuEt7w3GzwLYd1mq8xV1yU9DuDnfU+/FgLm+t/VAGhiIJBenouFoNDkobaDhZ1Vh9bcBhzXmIDTbcBd4qttJqmizbMTA3OIWiAYOrtkY4ULJnVtOJfL4Xi5CHjjJhNwiWxj6ipi9yEXBSxDXH17xYUZqzLLk/+HUh5uUHoMkkWewmDUQWaLpDsXBO5yQexyy/v/PES9fDN2Q7diI9zu00U+EsJaHw7REDZiI2zFRtiJjdDPXNEQKrFn0c9R0RD6OUoj/AZqAmCmXQoAAA==";
    private static final Log log = LogFactory.getLog(VradiTabHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton closeTab;
    protected JButton detachTab;
    protected String id;
    protected JLabel label;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VradiTabHeader $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiTabHeader() {
        $initialize();
    }

    public VradiTabHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCloseTab() {
        return closeTab;
    }

    public JButton getDetachTab() {
        return detachTab;
    }

    public String getId() {
        return id;
    }

    public JLabel getLabel() {
        return label;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setId(String id) {
        String oldValue = this.id;
        this.id = id;
        firePropertyChange(PROPERTY_ID, oldValue, id);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCloseTab() {
        $objectMap.put("closeTab", closeTab = new JButton());
        
        closeTab.setName("closeTab");
        closeTab.setBorderPainted(false);
        closeTab.setEnabled(true);
        closeTab.setFocusPainted(false);
        closeTab.setHorizontalTextPosition(0);
        closeTab.setOpaque(true);
        closeTab.setVerticalAlignment(0);
        closeTab.setVerticalTextPosition(0);
    }

    protected void createDetachTab() {
        $objectMap.put("detachTab", detachTab = new JButton());
        
        detachTab.setName("detachTab");
        detachTab.setBorderPainted(false);
        detachTab.setEnabled(true);
        detachTab.setFocusPainted(false);
        detachTab.setHorizontalTextPosition(0);
        detachTab.setOpaque(true);
        detachTab.setVerticalAlignment(0);
        detachTab.setVerticalTextPosition(0);
    }

    protected void createId() {
        $objectMap.put("id", id = null);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        if (label.getFont() != null) {
            label.setFont(label.getFont().deriveFont((float) 12));
        }
        label.setOpaque(false);
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(detachTab, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 15, 0, 0), 0, 0));
        add(closeTab, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 15, 0, 0), 0, 0));
        
        // apply 4 property setters
        detachTab.setIcon(SwingUtil.getUIManagerActionIcon("detach"));
        detachTab.setPreferredSize(new Dimension(16,16));
        closeTab.setIcon(SwingUtil.getUIManagerActionIcon("closeTab"));
        closeTab.setPreferredSize(new Dimension(16,16));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createId();
        createLabel();
        createDetachTab();
        createCloseTab();
        // inline creation of $Table0
        setName("$Table0");
        setOpaque(false);
        
        $completeSetup();
    }

}