/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import static org.nuiton.i18n.I18n._;

public class CreateOfferDialogUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FORM_TYPE = "formType";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";
    public static final String PROPERTY_NAME_VALUE = "nameValue";
    public static final String PROPERTY_OK = "ok";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS08TURQ+rbRQHoo0EIgQUUk0RqeYmGiEyNPGkiKJRSV2423n0l64nTveuQPTjfEn+BN078bEnSvjwrULN8a/YIwLt8ZzZ9pOB4o00sUUzuM73/nmnNO3PyDhSLiwQzzPkK6lWI0aa0tbWxulHVpWq9QpS2YrISH4xOIQL8KA2bI7Ci4V8zo900jPrIiaLSxqtWXP5aHfUXVOnSqlSsFUNKPsOJlCyz3n2a5sorZIdUJ9/etn/JX58k0cwLOR3SC2Mn1cVthJTx7izFQwgpX2SIYTq4I0JLMqyHdI21Y4cZwHpEafwwvozUPSJhLBFFzsvmUfw8/3bAXpsqRE0Y3tbSpXGeGi8iin4LqQFaNcFZLWjD1JTGa4zBA6xlg5HG/bPl5SQcpCbo8Jd6mCYU3Y0E0YQRNhWN+2kLXNuo1R13Qly2VKWMY+22VK1Q3kzRSjjvEkMNzzFLUcJqwQYayJUKAc5wJ968KkXMGEruoZzj4W1GqXxLLwfF+YHBe7Cs6G9JaF4JS0offObJISp7MKxiNvL0D1fToyFTY0s5YnJcoxY6SdQGDVQeNRjbKMcnzTo5HgTeqpJZQ3Gt/EvqH/n4r6hpoy+J0exGu2H81JlolV1lKlI8HLrsJ3cKC02A3NVxo+CeciouCyGOGyhNMcK0JCumhGFYuH9+shuoLNGj+wWRrQ9/4ZS3/98P19trlOA1h7tGNo2zXAMbelsKnUE6TgTLBLrmI8s07suSKkHH9k/FMx2YFYoeFGclgvGBOdbtwnThUhEr3fPn4ae/blFMSz0M8FMbNEx+cgpaoSVRDc9OyFRZ/R4H4fPoc1N1Sek7pAPeH0vEkUmS4xy0Tt73oowmQHEVpMSqnPv9OFd4tNIWJIbOLI8FCMxFNIMoszi/qXpXE0Ol6SAduhrinC49DpXMT0d7/dWJRZ/3mzU6eJmjAJjtjIfFB+mig8ASVXUWxWZ932u9B/3ekeFK9CsHgL/w/So3DJ/oExeSyGNuf041ZnhPPdIxzB4WKXCgeX5QgaM12A9OGPh0kllSfEGQxWipo5RWsnwjpOmssnRriKCH8B9nHvLGYIAAA=";
    private static final Log log = LogFactory.getLog(CreateOfferDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected CreateOfferDialogUI createOfferDialogUI = this;
    protected WikittyExtension formType;
    protected JComboBox formTypeCombo;
    protected ComboBoxModel formTypeSelectionModel;
    protected JTextArea nameField;
    protected String nameValue;
    protected Boolean ok;
    protected JButton okButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateOfferDialogUI() {
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Window param0) {
        super(param0);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateOfferDialogUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public CreateOfferDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__formTypeCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFormType((org.nuiton.wikitty.entities.WikittyExtension) formTypeCombo.getSelectedItem());
    }

    public void doActionPerformed__on__okButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setOk(true);dispose();
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setNameValue(nameField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public WikittyExtension getFormType() {
        return formType;
    }

    public JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public JTextArea getNameField() {
        return nameField;
    }

    public String getNameValue() {
        return nameValue;
    }

    public Boolean getOk() {
        return ok;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public Boolean isOk() {
        return ok !=null && ok;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFormType(WikittyExtension formType) {
        WikittyExtension oldValue = this.formType;
        this.formType = formType;
        firePropertyChange(PROPERTY_FORM_TYPE, oldValue, formType);
    }

    public void setFormTypeSelectionModel(ComboBoxModel formTypeSelectionModel) {
        ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = formTypeSelectionModel;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, formTypeSelectionModel);
    }

    public void setNameValue(String nameValue) {
        String oldValue = this.nameValue;
        this.nameValue = nameValue;
        firePropertyChange(PROPERTY_NAME_VALUE, oldValue, nameValue);
    }

    public void setOk(Boolean ok) {
        Boolean oldValue = this.ok;
        this.ok = ok;
        firePropertyChange(PROPERTY_OK, oldValue, ok);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCreateOfferDialogUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFormType() {
        $objectMap.put("formType", formType = null);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new JComboBox());
        
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel());
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextArea());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.setLineWrap(true);
        nameField.setWrapStyleWord(true);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameValue() {
        $objectMap.put("nameValue", nameValue = null);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = false);
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(_("vradi.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateOfferDialogUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(formTypeCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(okButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        formTypeCombo.setModel(formTypeSelectionModel);
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        // late initializer
        createOfferDialogUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createOfferDialogUI", createOfferDialogUI);
        createNameValue();
        createFormType();
        createFormTypeSelectionModel();
        createOk();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.createForm.askName"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.createForm.askType"));
        createFormTypeCombo();
        createCancel();
        createOkButton();
        // inline creation of createOfferDialogUI
        setName("createOfferDialogUI");
        createOfferDialogUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.admin.title"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NAME_FIELD_TEXT, true ,"nameValue") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(nameField, getNameValue());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true ,"formType") {
        
            @Override
            public void processDataBinding() {
                formTypeCombo.setSelectedItem(getFormType());
            }
        });
    }

}