/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ClientsNodeLoadors.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/loadors/ClientsNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.loadors;

import jaxx.runtime.swing.nav.NavDataProvider;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.chorem.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;

import java.util.Collections;
import java.util.List;

/** @author letellier */
public class ClientsNodeLoadors extends AbstractVradiNodeLoadors<Client> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6540304326033236054L;

    public ClientsNodeLoadors() {
        super(Client.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Return all clients
        // ne recupere pas seulement les id pour les mettre en cache
        VradiDataService dataService = getDataService(dataProvider);
        List<Client> clients = dataService.findAllClients();
        Collections.sort(clients, VradiComparators.CLIENT_COMPARATOR);
        return extractIds(clients);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}

