/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiAction.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/VradiAction.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi;

import jaxx.runtime.context.DefaultApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

import java.util.Arrays;

@DefaultApplicationContext.AutoLoad
public class VradiAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(VradiAction.class);

    /** La configuration de l'application. */
    protected ApplicationConfig config;

    public VradiAction() {
    }

    public VradiAction(ApplicationConfig config) {
        this.config = config;
    }

    public void configure() {
        disableMainUI();
//        VradiContext context = VradiContext.get();
//        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        handler.showConfig(context);
    }

    public void help() {
        disableMainUI();

        log.debug(I18n._("vradi.message.help.usage", VradiConfigHelper.getVersion(getConfig())));
        log.debug("Options (set with --option <key> <value>:");
        for (VradiConfig.VradiSwingOption o : VradiConfig.VradiSwingOption.values()) {
            log.debug("\t" + o.key + "(" + o.defaultValue + "):" + o.description);
        }

        log.debug("Actions:");
        for (VradiConfig.VradiSwingAction a : VradiConfig.VradiSwingAction.values()) {
            log.debug("\t" + Arrays.toString(a.aliases) + "(" + a.action + "):" + a.description);
        }
        System.exit(0);
    }
//
//    public void helpUI() {
//        VradiContext context = VradiContext.get();
////        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        VradiHelpBroker helpBroker = context.getContextValue(VradiHelpBroker.class);
//
//        log.debug("no mainUI, open in autonome frame");
//        // ouvrir dans une fenetre dedie
//        JHelp ui = new JHelp(helpBroker.getHelpset());
//        JDialog frame = new JDialog((Frame) null, true);
//        frame.setTitle(_("vradi.help.top.title"));
//        frame.setSize(1024, 800);
//        frame.add(ui);
//        frame.setVisible(true);
//
//        disableMainUI();
//
//        System.exit(0);
//    }

    /** Désactiver la possiblite de lancer l'ui principale. */
    public void disableMainUI() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected ApplicationConfig getConfig() {
        if (config == null) {
            VradiContext context = VradiContext.get();
            config = context.getContextValue(ApplicationConfig.class);
        }
        return config;
    }
}
