/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.BindingManager;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.ThesaurusManager;
import org.chorem.vradi.services.tasks.ImportXmlStreamTasks;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyProxy;

public class AssignXmlStreamTasks
extends ImportXmlStreamTasks {
    private static final Log log = LogFactory.getLog(AssignXmlStreamTasks.class);
    private static final TimeLog timeLog = new TimeLog(AssignXmlStreamTasks.class, 5000L, 1000L);
    protected ThesaurusManager thesaurusManager;
    protected FormManager formManager;

    public AssignXmlStreamTasks(ApplicationConfig config, WikittyProxy wikittyProxy, BindingManager bindingManager, ThesaurusManager thesaurusManager, FormManager formManager, String xmlStreamId) {
        super(config, wikittyProxy, bindingManager, xmlStreamId);
        this.thesaurusManager = thesaurusManager;
        this.formManager = formManager;
    }

    @Override
    public void run() {
        super.run();
        long start = TimeLog.getTime();
        Set<String> createdFormsIds = this.importResult.getCreatedFormsIds();
        ArrayList<Form> toStore = new ArrayList<Form>();
        for (String formId : createdFormsIds) {
            try {
                List<Thesaurus> thesaurusProposed = this.thesaurusManager.proposeThesaurus(formId);
                if (thesaurusProposed.isEmpty()) continue;
                Form form = (Form)this.wikittyProxy.restore(Form.class, formId);
                form = this.formManager.updateForm(form, VradiServiceHelper.extractIds(thesaurusProposed));
                form.setStatus(this.formManager.getSelectionneStatus().getWikittyId());
                toStore.add(form);
            }
            catch (VradiException eee) {
                log.error((Object)("Failled to propose thesaurus for form : " + formId), (Throwable)eee);
            }
        }
        this.wikittyProxy.store(toStore);
        timeLog.log(start, "AssignXmlStreamTasks");
    }
}

