/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: FilterList.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/search/FilterList.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.services.search;

import org.apache.lucene.search.BooleanClause;

import java.util.ArrayList;
import java.util.List;

/**
 * <code>FilterList</code> is an union of <code>Filters</code>
 * which must obey the same <code>FilterList.Operator</code>.
 *
 * @author $Author: sletellier $
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 0.0.4
 */
public class FilterList implements Filter {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected Operator operator;

    protected List<Filter> filters;

    public static enum Operator {
        /** And. */
        FILTER_AND,
        /** Or. */
        FILTER_OR,
        /** Not. */
        FILTER_NOT;

        /**
         * Find operator corresponding to lucene {@link BooleanClause}
         * definition.
         *
         * @param booleanClause boolean clause to inspect
         * @return operator to use
         */
        public static Operator getOperator(BooleanClause booleanClause) {
            Operator operator = null;

            if (booleanClause != null && booleanClause.isProhibited()) {
                operator = FILTER_NOT;

            } else if (booleanClause != null && booleanClause.isRequired()) {
                operator = FILTER_AND;

            } else {
                operator = FILTER_OR;
            }

            return operator;
        }

        /**
         * Return lucene operator String value used to recompose decomposed query.
         *
         * @return lucene operator value
         */
        public String getValue() {
            String luceneOperator = null;
            switch (this) {
                case FILTER_NOT:
                    luceneOperator = "NOT";
                    break;
                case FILTER_AND:
                    luceneOperator = "AND";
                    break;
                case FILTER_OR:
                    luceneOperator = "OR";
                    break;
            }
            return luceneOperator;
        }
    }

    public FilterList() {
        this(Operator.FILTER_AND);
    }

    public FilterList(Operator operator) {
        this.operator = operator;
        filters = new ArrayList<Filter>();
    }

    public Operator getOperator() {
        return operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<Filter> getFilters() {
        return filters;
    }

    public boolean addFilter(Filter filter) {
        return filters.add(filter);
    }

}
