/*
 * #%L
 * $Id: VradiPDFCleanerService.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/VradiPDFCleanerService.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi.services;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.entities.Form;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/**
 * Wikitty service that clean generated pdf files when an extension is
 * stored (updated).
 * <p/>
 * If template is modified, new generation don't work because pdf file
 * already exists.
 *
 * @author chatellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public class VradiPDFCleanerService extends WikittyServiceDelegator {

    /** Log. */
    private static final Log log = LogFactory.getLog(VradiPDFCleanerService.class);

    protected ApplicationConfig config;

    public VradiPDFCleanerService(WikittyService delegate, ApplicationConfig config) {
        super(delegate);
        this.config = config;
    }

    /**
     * Return generated pdf file path containing form wikitty id and form version.
     *
     * @param form   form
     * @param config config
     * @return generated pdf file
     *         <p/>
     *         TODO echatellier 20110218 move this to a better place
     */
    public static File getGeneratedPdfFile(Form form, ApplicationConfig config) {
        String filename = form.getWikittyId() + "-" + form.getWikittyVersion() + ".pdf";
        File pdfDir = VradiServiceConfigurationHelper.getPdfDir(config);
        File result = new File(pdfDir, filename);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken,
                                       Collection<WikittyExtension> exts) {
        WikittyEvent event = super.storeExtension(securityToken, exts);

        //
        for (WikittyExtension ext : exts) {

            // only extension that require Form
            if (Form.EXT_FORM.equals(ext.getRequires())) {

                if (log.isInfoEnabled()) {
                    log.info("Removing generated pdf for extension " + ext.getName());
                }

                Search search = Search.query().eq(Element.ELT_EXTENSION, ext.getName());
                Criteria criteria = search.criteria();
                List<PagedResult<String>> allFormId = findAllByCriteria(
                        securityToken,
                        Arrays.asList(criteria)
                );

                if (CollectionUtils.isNotEmpty(allFormId)) {
                    for (String formId : allFormId.get(0).getAll()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Delete all pdf files for form " + formId);
                        }

                        // remove all files named formid*.pdf
                        File generatedPdfDir = VradiServiceConfigurationHelper.getPdfDir(config);
                        String filePattern = Pattern.quote(formId) + ".*\\.pdf";
                        List<File> pdfFiles = FileUtil.find(generatedPdfDir, filePattern, false);
                        for (File pdfFile : pdfFiles) {
                            if (log.isDebugEnabled()) {
                                log.debug("Delete pdf file " + pdfFile);
                            }
                            pdfFile.delete();
                        }
                    }
                }
            }
        }

        return event;
    }
}
