/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.MoreLikeThisHandler;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.SolrIndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoreLikeThisComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "mlt";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams p = rb.req.getParams();
        if (p.getBool(COMPONENT_NAME, false)) {
            SolrIndexSearcher searcher = rb.req.getSearcher();
            NamedList<DocList> sim = this.getMoreLikeThese(rb, searcher, rb.getResults().docList, rb.getFieldFlags());
            rb.rsp.add("moreLikeThis", sim);
        }
    }

    NamedList<DocList> getMoreLikeThese(ResponseBuilder rb, SolrIndexSearcher searcher, DocList docs, int flags) throws IOException {
        SolrParams p = rb.req.getParams();
        IndexSchema schema = searcher.getSchema();
        MoreLikeThisHandler.MoreLikeThisHelper mltHelper = new MoreLikeThisHandler.MoreLikeThisHelper(p, searcher);
        SimpleOrderedMap mlt = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        SimpleOrderedMap dbg = null;
        if (rb.isDebug()) {
            dbg = new SimpleOrderedMap();
        }
        while (iterator.hasNext()) {
            int id = iterator.nextDoc();
            int rows = p.getInt("mlt.count", 5);
            DocListAndSet sim = mltHelper.getMoreLikeThis(id, 0, rows, null, null, flags);
            String name = schema.printableUniqueKey(searcher.doc(id));
            mlt.add(name, (Object)sim.docList);
            if (dbg == null) continue;
            SimpleOrderedMap docDbg = new SimpleOrderedMap();
            docDbg.add("rawMLTQuery", (Object)mltHelper.getRawMLTQuery().toString());
            docDbg.add("boostedMLTQuery", (Object)mltHelper.getBoostedMLTQuery().toString());
            docDbg.add("realMLTQuery", (Object)mltHelper.getRealMLTQuery().toString());
            SimpleOrderedMap explains = new SimpleOrderedMap();
            DocIterator mltIte = sim.docList.iterator();
            while (mltIte.hasNext()) {
                int mltid = mltIte.nextDoc();
                String key = schema.printableUniqueKey(searcher.doc(mltid));
                explains.add(key, (Object)searcher.explain(mltHelper.getRealMLTQuery(), mltid));
            }
            docDbg.add("explain", (Object)explains);
            dbg.add(name, (Object)docDbg);
        }
        if (dbg != null) {
            rb.addDebugInfo("moreLikeThis", dbg);
        }
        return mlt;
    }

    @Override
    public String getDescription() {
        return "More Like This";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1064775 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: MoreLikeThisComponent.java 1064775 2011-01-28 16:58:46Z koji $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_1/solr/src/java/org/apache/solr/handler/component/MoreLikeThisComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

