/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.tasks;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.MailingManager;

public class AutoSendTasks
extends TimerTask {
    private static final Log log = LogFactory.getLog(AutoSendTasks.class);
    protected FormManager formManager;
    protected MailingManager mailingManager;

    public AutoSendTasks(FormManager formManager, MailingManager mailingManager) {
        this.formManager = formManager;
        this.mailingManager = mailingManager;
    }

    @Override
    public void run() {
        try {
            Session session = this.formManager.getLastOpenSession();
            if (session == null) {
                session = this.formManager.createNewSession();
            }
            session = this.formManager.bindForms(session);
            String sessionId = session.getWikittyId();
            this.mailingManager.generatePDFForSession(sessionId);
            String logs = this.mailingManager.sendMessages(sessionId);
            log.info((Object)("Send email is finished : " + logs));
        }
        catch (VradiException e) {
            log.error((Object)"Failled to auto send session");
        }
    }
}

