/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.admin;

import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

public class SummaryPoll
extends PollenActionSupport
implements PollenUserSecurityAware {
    private static final long serialVersionUID = 1L;

    public SummaryPoll() {
        super(PageSkin.EDITION);
    }

    public Poll getPoll() {
        return this.getUserSecurityContext().getPoll();
    }

    public String getVoteUrl() {
        PollUrl url = this.getPollUrlService().getPollVoteUrl(this.getPoll());
        if (this.getPoll().isPollFree()) {
            this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        } else if (this.getUserSecurityContext().isRestrictedVoter() && !this.getUserSecurityContext().isConnected()) {
            url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        }
        return url.getUrl();
    }

    public String getShowVoteUrl() {
        PollUrl url = this.getPollUrlService().getPollVoteUrl(this.getPoll());
        if (this.getPoll().isPollFree()) {
            this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        }
        return url.getUrl();
    }

    public String getModerateUrl() {
        PollUrl url = this.getPollUrlService().getPollModerateUrl(this.getPoll());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getEditUrl() {
        PollUrl url = this.getPollUrlService().getPollEditUrl(this.getPoll());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getCloneUrl() {
        PollUrl url = this.getPollUrlService().getPollCloneUrl(this.getPoll());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getExportUrl() {
        PollUrl url = this.getPollUrlService().getPollExportUrl(this.getPoll());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = this.getPollUrlService().getPollResultUrl(this.getPoll());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public boolean isCanClose() {
        return this.getSecurityService().isCanClosePoll(this.getUserSecurityContext());
    }

    public boolean isCanShowVote() {
        return this.getPoll().isPublicResults() && !this.isCanVote();
    }

    public boolean isCanShowResult() {
        boolean result = this.getSecurityService().isCanAccessResult(this.getUserSecurityContext());
        return result;
    }

    public boolean isCanVote() {
        return this.getSecurityService().isCanVote(this.getUserSecurityContext());
    }

    public String execute() throws Exception {
        return "success";
    }
}

