/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;

public class AttachPoll
extends AbstractPollUriIdAction {
    private static final long serialVersionUID = 1L;

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public String execute() throws Exception {
        String pollId = this.getPollId();
        Preconditions.checkNotNull((Object)pollId);
        Poll poll = this.getPollService().getExistingPollByPollId(pollId);
        UserAccount userAccount = this.getPollenSession().getUserAccount();
        this.getPollService().attachPoll(poll, userAccount);
        this.addFlashMessage(this._("pollen.information.poll.attached", new Object[]{poll.getTitle()}));
        return "success";
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.getPollId())) {
            this.addFieldError("uriId", this._("pollen.error.pollId.empty", new Object[0]));
        } else {
            String pollId = this.getPollId();
            try {
                Poll poll = this.getPollService().getExistingPollByPollId(pollId);
                UserAccount userAccount = poll.getCreator().getUserAccount();
                if (userAccount != null) {
                    this.addFieldError("uriId", this._("pollen.error.pollAlreadyAttached", new Object[0]));
                }
            }
            catch (PollNotFoundException e) {
                this.addFieldError("uriId", this._("pollen.error.pollNotFound", new Object[0]));
            }
        }
    }
}

