/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.ActionContext;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;
import org.chorem.pollen.PollenApplicationContext;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.services.impl.PollCommentService;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PollResultsService;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.PollUrlService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.services.impl.VoteService;
import org.chorem.pollen.ui.PollenSession;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.framework.TopiaTransactionAware;
import org.nuiton.web.filter.TopiaTransactionFilter;
import org.nuiton.web.struts2.BaseAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class PollenActionSupport
extends BaseAction
implements TopiaTransactionAware {
    private static final long serialVersionUID = 1L;
    private transient PollenSession pollenSession;
    protected transient PollenServiceFactory serviceFactory;
    protected transient PollenServiceContext serviceContext;
    protected transient TopiaContext transaction;
    private transient PollService pollService;
    private transient PollUrlService pollUrlService;
    private transient PollResultsService pollResultsService;
    private transient VoteService voteService;
    private transient PollCommentService pollCommentService;
    private transient PollFeedService pollFeedService;
    private transient UserService userService;
    private transient FavoriteService favoriteService;
    private transient PreventRuleService preventRuleService;
    private transient SecurityService securityService;
    public static final List<String> SAFE_LANGUAGES = Lists.newArrayList((Object[])new String[]{"en", "fr"});

    public static PollenApplicationContext getPollenApplicationContext() {
        PollenApplicationContext applicationContext = PollenApplicationContext.get((ActionContext)PollenActionSupport.getActionContext());
        return applicationContext;
    }

    public PollenConfiguration getConfiguration() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration();
    }

    public PageSkin getSkin() {
        return PageSkin.INDEX;
    }

    public String getPageLogo() {
        return this.getSkin().getCssSuffix();
    }

    public String getJqueryTheme() {
        return this.getSkin().getTheme();
    }

    public PollenSession getPollenSession() {
        if (this.pollenSession == null) {
            this.pollenSession = PollenSession.get((ActionContext)PollenActionSupport.getActionContext());
        }
        return this.pollenSession;
    }

    public UserAccount getPollenUserAccount() {
        return this.getPollenSession().getUserAccount();
    }

    public boolean isUserLoggued() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null;
    }

    public boolean isUserAdmin() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null && userAccount.isAdministrator();
    }

    public static String getApplicationVersion() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration().getVersion().toString();
    }

    public URL getApplicationUrl() {
        URL url = this.getServiceContext().getApplicationURL();
        return url;
    }

    protected PollenServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = DefaultPollenServiceContext.newContext((Locale)this.getLocale(), (TopiaContext)this.getTransaction(), (PollenConfiguration)this.getConfiguration(), (PollenServiceFactory)this.getServiceFactory());
        }
        return this.serviceContext;
    }

    public PollenServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new PollenServiceFactory();
        }
        return this.serviceFactory;
    }

    public <E extends PollenService> E newService(Class<E> serviceClass) {
        PollenService service = this.getServiceFactory().newService(serviceClass, this.getServiceContext());
        return (E)service;
    }

    public TopiaContext getTransaction() {
        if (this.transaction == null) {
            HttpServletRequest request = (HttpServletRequest)PollenActionSupport.getActionContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.transaction = TopiaTransactionFilter.getTransaction((ServletRequest)request);
        }
        return this.transaction;
    }

    public void setTransaction(TopiaContext transaction) {
        this.transaction = transaction;
    }

    public String getSafeLanguage() {
        String language = this.getLocale().getLanguage();
        if (!SAFE_LANGUAGES.contains(language)) {
            language = (String)SAFE_LANGUAGES.get(0);
        }
        return language;
    }

    protected static ActionContext getActionContext() {
        return ActionContext.getContext();
    }

    public static Date getCurrentDateTime() {
        return new Date();
    }

    public String getVoteCountingTypeHelp(VoteCountingType voteCountingType) {
        String result;
        switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[voteCountingType.ordinal()]) {
            default: {
                result = this._("pollen.common.voteCountingTypeHelp.normal", new Object[0]);
                break;
            }
            case 2: {
                result = this._("pollen.common.voteCountingTypeHelp.percentage", new Object[0]);
                break;
            }
            case 3: {
                result = this._("pollen.common.voteCountingTypeHelp.condorcet", new Object[0]);
                break;
            }
            case 4: {
                result = this._("pollen.common.voteCountingTypeHelp.number", new Object[0]);
            }
        }
        return result;
    }

    public String getCurrentUrl() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String result = request.getRequestURL().toString();
        return result;
    }

    public void addFlashMessage(String message) {
        this.getPollenSession().addMessage("messages", message);
    }

    public void addFlashError(String message) {
        this.getPollenSession().addMessage("errors", message);
    }

    public void addFlashWarning(String message) {
        this.getPollenSession().addMessage("warnings", message);
    }

    public Collection<String> getFlashMessages() {
        List result = (List)this.getPollenSession().consumeDynamicData("messages");
        return result;
    }

    public Collection<String> getFlashErrors() {
        List result = (List)this.getPollenSession().consumeDynamicData("errors");
        return result;
    }

    public Collection<String> getFlashWarnings() {
        List result = (List)this.getPollenSession().consumeDynamicData("warnings");
        return result;
    }

    public boolean hasFlashMessages() {
        List result = (List)this.getPollenSession().getDynamicData("messages");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashErrors() {
        List result = (List)this.getPollenSession().getDynamicData("errors");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashWarnings() {
        List result = (List)this.getPollenSession().getDynamicData("warnings");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public void clearFlashMessages() {
        List result = (List)this.getPollenSession().getDynamicData("messages");
        if (result != null) {
            result.clear();
        }
    }

    public void clearFlashErrors() {
        List result = (List)this.getPollenSession().getDynamicData("errors");
        if (result != null) {
            result.clear();
        }
    }

    public boolean hasAnyErrors() {
        boolean result = super.hasErrors();
        return result || this.hasFlashErrors();
    }

    protected final PollService getPollService() {
        if (this.pollService == null) {
            this.pollService = (PollService)this.newService(PollService.class);
        }
        return this.pollService;
    }

    protected final PollUrlService getPollUrlService() {
        if (this.pollUrlService == null) {
            this.pollUrlService = (PollUrlService)this.newService(PollUrlService.class);
        }
        return this.pollUrlService;
    }

    protected final PollResultsService getPollResultsService() {
        if (this.pollResultsService == null) {
            this.pollResultsService = (PollResultsService)this.newService(PollResultsService.class);
        }
        return this.pollResultsService;
    }

    protected final VoteService getVoteService() {
        if (this.voteService == null) {
            this.voteService = (VoteService)this.newService(VoteService.class);
        }
        return this.voteService;
    }

    protected final PollCommentService getPollCommentService() {
        if (this.pollCommentService == null) {
            this.pollCommentService = (PollCommentService)this.newService(PollCommentService.class);
        }
        return this.pollCommentService;
    }

    protected final PollFeedService getPollFeedService() {
        if (this.pollFeedService == null) {
            this.pollFeedService = (PollFeedService)this.newService(PollFeedService.class);
        }
        return this.pollFeedService;
    }

    protected final UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    protected final FavoriteService getFavoriteService() {
        if (this.favoriteService == null) {
            this.favoriteService = (FavoriteService)this.newService(FavoriteService.class);
        }
        return this.favoriteService;
    }

    protected final PreventRuleService getPreventRuleService() {
        if (this.preventRuleService == null) {
            this.preventRuleService = (PreventRuleService)this.newService(PreventRuleService.class);
        }
        return this.preventRuleService;
    }

    public SecurityService getSecurityService() {
        if (this.securityService == null) {
            this.securityService = (SecurityService)this.newService(SecurityService.class);
        }
        return this.securityService;
    }
}

