/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ClosePoll.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ClosePoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.chorem.pollen.business.persistence.Poll;

/**
 * Closes an existing poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ClosePoll extends AbstractPollUriIdAction {

    private static final long serialVersionUID = 1L;

    /**
     * Redirect url.
     *
     * @since 1.3
     */
    protected String redirectUrl;

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String execute() throws Exception {

        Poll poll = getPollService().getExistingPollByPollId(getPollId());

        getPollService().closePoll(getPollId(),
                                   getPollenUserAccount(),
                                   getAccountId());

        addFlashMessage(_("pollen.information.poll.closed", poll.getTitle()));

        return SUCCESS;
    }
}
