/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AddChoice.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AddChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.bean.ChoiceHelper;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.FileUploadAware;

import java.io.File;
import java.util.List;

/**
 * To add a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class AddChoice extends AbstractVoteAction implements Preparable, FileUploadAware {

    private static final long serialVersionUID = 1L;

    protected Choice choice;

    private List<File> imageChoices;

    private List<String> imageChoiceContentTypes;

    private List<String> imageChoiceFileNames;

    public Choice getChoice() {
        return choice;
    }

    @Override
    public void setFiles(String paramName, List<File> files) {
        this.imageChoices = Lists.newArrayList(files);
    }

    @Override
    public void setFileContentTypes(String paramName, List<String> contentTypes) {
        this.imageChoiceContentTypes = Lists.newArrayList(contentTypes);
    }

    @Override
    public void setFileNames(String paramName, List<String> fileNames) {
        this.imageChoiceFileNames = Lists.newArrayList(fileNames);
    }

    public List<File> getImageChoices() {
        if (imageChoices == null) {
            imageChoices = Lists.newArrayList();
        }
        return imageChoices;
    }

    public List<String> getImageChoiceContentTypes() {
        if (imageChoiceContentTypes == null) {
            imageChoiceContentTypes = Lists.newArrayList();
        }
        return imageChoiceContentTypes;
    }

    public List<String> getImageChoiceFileNames() {
        if (imageChoiceFileNames == null) {
            imageChoiceFileNames = Lists.newArrayList();
        }
        return imageChoiceFileNames;
    }

    @Override
    public void prepare() throws PollNotFoundException {

        loadPoll();

        ChoiceType choiceType = getPoll().getChoiceType();
        choice = getPollService().getNewChoice(choiceType);

        // Push image choice data from uploaded file
        if (ChoiceType.IMAGE == choiceType && getImageChoices().size() == 1) {

            String fileName = getImageChoiceFileNames().get(0);
            String location = getImageChoices().get(0).getAbsolutePath();
            choice.setName(fileName);
            ((PollImageChoice)choice).setLocation(location);
        }
    }

    @Override
    public void validate() {

        ChoiceType choiceType = getPoll().getChoiceType();

        String propName = ChoiceHelper.getValuePropertyName(choiceType);
        
        Object value = ChoiceHelper.toValue(choice, choiceType);

        // -- Validate value notEmpty
        if (value == null || (value instanceof String && StringUtils.isBlank((String) value))) {
            String typeLabel = getText(choiceType.getI18nKey());
            addFieldError("choice." + propName,
                          _("pollen.error.choice.empty", typeLabel));
        } else {

            // Retrieve existing values to check if the new choice not already exists
            Iterable<Object> pollChoiceValues = ChoiceHelper.toValues(getPoll().getChoice(), choiceType);

            // -- Validate value notExists
            if (Iterables.contains(pollChoiceValues, value)) {
                addFieldError("choice." + propName,
                              _("pollen.error.poll.detected.duplicate.choice.name"));
            }
        }
    }

    @InputConfig(methodName = "prepareVotePage")
    @Override
    public String execute() throws Exception {

        getPollService().createChoice(getPollId(), choice);

        return SUCCESS;
    }

}
