/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.CommentDao;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.services.bean.CommentBean;
import org.chorem.pollen.services.bean.CommentInputsBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class CommentService
extends PollenServiceSupport {
    protected CommentBean toCommentBean(Comment entity) {
        CommentBean bean = new CommentBean();
        bean.setEntityId(entity.getTopiaId());
        PollenPrincipal author = entity.getAuthor();
        if (author.getPermission() == null || this.isNotPermitted(PollenPermissions.edit(entity))) {
            bean.setPermission(null);
        } else {
            bean.setPermission(author.getPermission().getToken());
        }
        bean.setText(entity.getText());
        bean.setPostDate(entity.getPostDate());
        bean.setAuthorName(author.getName());
        Optional.ofNullable(author.getPollenUser()).map(PollenUser::getAvatar).map(AbstractPollenEntity::getTopiaId).map(this.getPollenResourceService()::getReduceIdByTopiaId).ifPresent(bean::setAuthorAvatar);
        if (this.isPermitted(PollenPermissions.edit(entity))) {
            ReportResumeBean report = this.getReportService().getReport(entity.getTopiaId());
            bean.setReport(report);
        }
        return bean;
    }

    public PaginationResult<CommentBean> getComments(PollenEntityId<Poll> pollId, PaginationParameter page) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        PaginationParameter orderedPage = CommentService.orderedPage(page);
        PaginationResult comments = this.getCommentDao().find(poll, orderedPage);
        return comments.transform(this::toCommentBean);
    }

    public PaginationResult<CommentBean> getQuestionComments(String pollId, String questionId, PaginationParameter page) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.readComments(question));
        PaginationParameter orderedPage = CommentService.orderedPage(page);
        PaginationResult comments = this.getCommentDao().find(question, orderedPage);
        return comments.transform(this::toCommentBean);
    }

    public long getCommentCount(Poll poll) {
        this.checkIsConnectedRequired();
        return this.getCommentDao().forPollEquals(poll).count();
    }

    public long getQuestionCommentCount(Question question) {
        this.checkIsConnectedRequired();
        return this.getCommentDao().forQuestionEquals(question).count();
    }

    public CommentBean getNewComment(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.addComment(poll));
        CommentBean commentBean = new CommentBean();
        this.getSecurityContext().getPrincipalOrConnectedUserName().ifPresent(commentBean::setAuthorName);
        return commentBean;
    }

    public CommentBean getNewQuestionComment(String pollId, String questionId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.addComment(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.addComment(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        CommentBean commentBean = new CommentBean();
        this.getSecurityContext().getPrincipalOrConnectedUserName().ifPresent(commentBean::setAuthorName);
        return commentBean;
    }

    public CommentBean getComment(String pollId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        Comment comment = this.getComment(poll, commentId);
        return this.toCommentBean(comment);
    }

    public CommentBean getQuestionComment(String pollId, String questionId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.addComment(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Comment comment = this.getComment(question, commentId);
        return this.toCommentBean(comment);
    }

    @Deprecated
    public PollenEntityRef<Comment> addComment(String pollId, CommentBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(comment);
        this.checkIsNotPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.addComment(poll));
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(poll, comment);
        this.commit();
        this.getNotificationService().onCommentAdded(poll, result);
        this.getFeedService().onCommentAdded(poll, result);
        return PollenEntityRef.of(result);
    }

    public PollenEntityRef<Comment> createComment(PollenEntityId<Poll> pollId, CommentInputsBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(comment);
        this.checkIsNotPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.addComment(poll));
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(poll, comment);
        this.commit();
        this.getNotificationService().onCommentAdded(poll, result);
        this.getFeedService().onCommentAdded(poll, result);
        return PollenEntityRef.of(result);
    }

    public PollenEntityRef<Comment> addQuestionComment(String pollId, String questionId, CommentBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(comment);
        this.checkIsNotPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.addComment(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.addComment(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(question, comment);
        this.commit();
        this.getNotificationService().onCommentAdded(question, result);
        this.getFeedService().onCommentAdded(question, result);
        return PollenEntityRef.of(result);
    }

    @Deprecated
    public CommentBean editComment(String pollId, CommentBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(comment);
        this.checkIsPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        Comment commentBd = this.getComment(poll, comment.getEntityId());
        this.checkPermission(PollenPermissions.edit(commentBd));
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(poll, comment);
        this.commit();
        this.getNotificationService().onCommentEdited(poll, result);
        this.getFeedService().onCommentEdited(poll, result);
        return this.toCommentBean(result);
    }

    public PollenEntityRef<Comment> updateComment(PollenEntityId<Poll> pollId, CommentInputsBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(comment);
        this.checkIsPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        Comment commentBd = this.getComment(poll, comment.commentId());
        this.checkPermission(PollenPermissions.edit(commentBd));
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(poll, comment);
        this.commit();
        this.getNotificationService().onCommentEdited(poll, result);
        this.getFeedService().onCommentEdited(poll, result);
        return PollenEntityRef.of(result);
    }

    public CommentBean editQuestionComment(String pollId, String questionId, CommentBean comment) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(comment);
        this.checkIsPersisted(comment);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Comment commentBd = this.getComment(poll, comment.getEntityId());
        this.checkPermission(PollenPermissions.edit(commentBd));
        ErrorMap errorMap = this.checkComment(comment);
        errorMap.failIfNotEmpty();
        Comment result = this.saveComment(poll, comment);
        this.commit();
        this.getNotificationService().onCommentEdited(question, result);
        this.getFeedService().onCommentEdited(question, result);
        return this.toCommentBean(result);
    }

    public void deleteComment(String pollId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Comment comment = this.getComment(poll, commentId);
        this.checkPermission(PollenPermissions.delete(comment));
        this.getCommentDao().delete(comment);
        this.commit();
        this.getNotificationService().onCommentDeleted(poll, comment);
        this.getFeedService().onCommentDeleted(poll, comment);
    }

    public void deleteQuestionComment(String pollId, String questionId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Comment comment = this.getComment(question, commentId);
        this.checkPermission(PollenPermissions.delete(comment));
        this.getCommentDao().delete(comment);
        this.commit();
        this.getNotificationService().onCommentDeleted(poll, comment);
        this.getFeedService().onCommentDeleted(poll, comment);
    }

    @Deprecated
    protected Comment getComment(Poll poll, String commentId) {
        Comment result = (Comment)this.getCommentDao().forTopiaIdEquals(commentId).findUnique();
        if (!poll.equals((Object)result.getPoll())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)result, (PollenEntity)poll);
        }
        return result;
    }

    protected Comment getComment(Poll poll, PollenEntityId<Comment> commentId) {
        Comment result = (Comment)this.getCommentDao().forTopiaIdEquals(commentId.getEntityId()).findUnique();
        if (!poll.equals((Object)result.getPoll())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)result, (PollenEntity)poll);
        }
        return result;
    }

    protected Comment getComment(Question question, String commentId) {
        Comment result = (Comment)this.getCommentDao().forTopiaIdEquals(commentId).findUnique();
        if (!question.equals((Object)result.getQuestion())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)result, (PollenEntity)question);
        }
        return result;
    }

    @Deprecated
    protected ErrorMap checkComment(CommentBean comment) {
        ErrorMap errors = new ErrorMap();
        this.checkNotBlank(errors, "text", comment.getText(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.comment.text.mandatory", (Object[])new Object[0]));
        this.checkNotBlank(errors, "author.name", comment.getAuthorName(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.comment.author.name.mandatory", (Object[])new Object[0]));
        return errors;
    }

    protected ErrorMap checkComment(CommentInputsBean comment) {
        ErrorMap errors = new ErrorMap();
        this.checkNotBlank(errors, "text", comment.text(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.comment.text.mandatory", (Object[])new Object[0]));
        this.checkNotBlank(errors, "author.name", comment.authorName(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.comment.author.name.mandatory", (Object[])new Object[0]));
        return errors;
    }

    @Deprecated
    protected Comment saveComment(Poll poll, CommentBean comment) {
        Comment toSave;
        boolean commentExists = comment.isPersisted();
        CommentDao commentDao = this.getCommentDao();
        if (commentExists) {
            toSave = (Comment)commentDao.forTopiaIdEquals(comment.getEntityId()).findUnique();
        } else {
            toSave = (Comment)commentDao.newInstance();
            toSave.setText(comment.getText());
            toSave.setPostDate(this.serviceContext.getNow());
            PollenPrincipal author = this.getSecurityService().generatePollenPrincipal();
            toSave.setAuthor(author);
            toSave.setPoll(poll);
            commentDao.create((PollenEntity)toSave);
        }
        toSave.setText(comment.getText());
        PollenUser connectedUser = this.getConnectedUser();
        if (connectedUser != null) {
            toSave.getAuthor().setPollenUser(connectedUser);
        }
        toSave.getAuthor().setName(comment.getAuthorName());
        return toSave;
    }

    protected Comment saveComment(Poll poll, CommentInputsBean comment) {
        Comment toSave;
        boolean commentExists = comment.isPersisted();
        CommentDao commentDao = this.getCommentDao();
        if (commentExists) {
            toSave = (Comment)commentDao.forTopiaIdEquals(comment.commentId().getEntityId()).findUnique();
        } else {
            toSave = (Comment)commentDao.newInstance();
            toSave.setText(comment.text());
            toSave.setPostDate(this.serviceContext.getNow());
            PollenPrincipal author = this.getSecurityService().generatePollenPrincipal();
            toSave.setAuthor(author);
            toSave.setPoll(poll);
            commentDao.create((PollenEntity)toSave);
        }
        toSave.setText(comment.text());
        PollenUser connectedUser = this.getConnectedUser();
        if (connectedUser != null) {
            toSave.getAuthor().setPollenUser(connectedUser);
        }
        toSave.getAuthor().setName(comment.authorName());
        return toSave;
    }

    protected Comment saveComment(Question question, CommentBean comment) {
        Comment toSave;
        boolean commentExists = comment.isPersisted();
        CommentDao commentDao = this.getCommentDao();
        if (commentExists) {
            toSave = (Comment)commentDao.forTopiaIdEquals(comment.getEntityId()).findUnique();
        } else {
            toSave = (Comment)commentDao.newInstance();
            toSave.setPostDate(this.serviceContext.getNow());
            toSave.setText(comment.getText());
            PollenPrincipal author = this.getSecurityService().generatePollenPrincipal();
            toSave.setAuthor(author);
            toSave.setQuestion(question);
            commentDao.create((PollenEntity)toSave);
        }
        toSave.setText(comment.getText());
        PollenUser connectedUser = this.getConnectedUser();
        if (connectedUser != null) {
            toSave.getAuthor().setPollenUser(connectedUser);
        }
        toSave.getAuthor().setName(comment.getAuthorName());
        return toSave;
    }
}

