/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollVoteVisibility;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.services.PollenServiceSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class SecurityService
extends PollenServiceSupport {
    public Set<PollenUserSecurityContext.PollenUserSecurityRole> getUserRoles(Poll poll, String accountId, UserAccount userAccount) {
        Preconditions.checkNotNull((Object)poll);
        EnumSet<PollenUserSecurityContext.PollenUserSecurityRole> result = EnumSet.noneOf(PollenUserSecurityContext.PollenUserSecurityRole.class);
        if (StringUtils.isNotBlank((CharSequence)accountId) || userAccount != null) {
            boolean creator = this.isPollCreator(poll, accountId, userAccount);
            if (creator) {
                result.add(PollenUserSecurityContext.PollenUserSecurityRole.CREATOR);
            }
            if (poll.isPollFree()) {
                boolean found = this.isVoterAccountId(poll, accountId, userAccount);
                if (found) {
                    result.add(PollenUserSecurityContext.PollenUserSecurityRole.VOTER);
                }
            } else {
                boolean found = this.isRestrictAccountId(poll, accountId, userAccount);
                if (found) {
                    result.add(PollenUserSecurityContext.PollenUserSecurityRole.RESTRICTED_VOTER);
                }
            }
        }
        return result;
    }

    public boolean isCanAccessResult(PollenUserSecurityContext securityContext) {
        String errorMessage = this.checkAccessResult(securityContext);
        return errorMessage == null;
    }

    public String checkAccessResult(PollenUserSecurityContext securityContext) {
        Poll poll = securityContext.getPoll();
        boolean publicResults = poll.isPublicResults();
        boolean continuousResults = poll.isContinuousResults();
        if (!continuousResults && !poll.isClosed()) {
            return I18n.n_((String)"pollen.security.error.poll.not.closed.and.results.not.continuous", (Object[])new Object[0]);
        }
        if (!publicResults) {
            return I18n.n_((String)"pollen.security.error.poll.result.private.and.access.not.granted", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isCanAccessVote(PollenUserSecurityContext securityContext) {
        return this.checkCanAccessVote(securityContext) == null;
    }

    public String checkCanAccessVote(PollenUserSecurityContext securityContext) {
        Poll poll = securityContext.getPoll();
        if (securityContext.isCreator()) {
            return null;
        }
        if (securityContext.isAdmin()) {
            return null;
        }
        if (poll.isPublicResults()) {
            return null;
        }
        if (!poll.isPollFree() && !securityContext.isRestrictedVoter()) {
            return I18n.n_((String)"pollen.security.error.poll.not.free.and.access.not.granted", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isCanVote(PollenUserSecurityContext securityContext) {
        Date now;
        Poll poll = securityContext.getPoll();
        if (!poll.isRunning(now = this.serviceContext.getCurrentTime())) {
            return false;
        }
        return poll.isPollFree() || securityContext.isRestrictedVoter();
    }

    public boolean isCanModifyVote(PollenUserSecurityContext securityContext, String voteId) {
        Poll poll = securityContext.getPoll();
        String accountId = securityContext.getAccountId();
        UserAccount userConnected = securityContext.getUserAccount();
        Date now = this.serviceContext.getCurrentTime();
        if (!poll.isRunning(now)) {
            return false;
        }
        Vote vote = poll.getVoteByTopiaId(voteId);
        if (vote == null) {
            return false;
        }
        PollAccount votePollAccount = vote.getPollAccount();
        if (votePollAccount.getAccountId().equals(accountId)) {
            return true;
        }
        if (userConnected != null) {
            if (userConnected.equals(votePollAccount.getUserAccount())) {
                return true;
            }
            if (userConnected.getEmail().equals(votePollAccount.getEmail())) {
                return true;
            }
        }
        return false;
    }

    public boolean isCanDeleteComment(PollenUserSecurityContext securityContext, Comment comment) {
        String accountId = securityContext.getAccountId();
        UserAccount userAccount = securityContext.getUserAccount();
        if (securityContext.isCreator()) {
            return true;
        }
        PollAccount commentAccount = comment.getPollAccount();
        if (commentAccount.getAccountId().equals(accountId)) {
            return true;
        }
        return userAccount != null && userAccount.equals(commentAccount.getUserAccount());
    }

    public boolean isCanDeleteVote(PollenUserSecurityContext securityContext, String voteId) {
        Poll poll = securityContext.getPoll();
        String accountId = securityContext.getAccountId();
        UserAccount userConnected = securityContext.getUserAccount();
        Date now = this.serviceContext.getCurrentTime();
        if (!poll.isRunning(now)) {
            return false;
        }
        Vote vote = poll.getVoteByTopiaId(voteId);
        if (vote == null) {
            return false;
        }
        if (securityContext.isCreator()) {
            return true;
        }
        PollAccount votePollAccount = vote.getPollAccount();
        if (votePollAccount.getAccountId().equals(accountId)) {
            return true;
        }
        if (userConnected != null) {
            if (userConnected.equals(votePollAccount.getUserAccount())) {
                return true;
            }
            if (userConnected.getEmail().equals(votePollAccount.getEmail())) {
                return true;
            }
        }
        return false;
    }

    public boolean isCanClosePoll(PollenUserSecurityContext securityContext) {
        boolean result;
        Poll poll = securityContext.getPoll();
        boolean bl = result = !poll.isClosed();
        if (result) {
            result = securityContext.isCreator();
        }
        return result;
    }

    public List<Vote> filterVotes(Poll poll, List<Vote> allVotes, PollenUserSecurityContext userSecurityContext) {
        ArrayList result;
        block13: {
            result = null;
            PollVoteVisibility voteVisibility = poll.getPollVoteVisibility();
            switch (voteVisibility) {
                case NOBODY: {
                    break;
                }
                case CREATOR_ONLY: {
                    if (!userSecurityContext.isAdmin() && !userSecurityContext.isCreator()) break;
                    result = allVotes;
                    break;
                }
                case PARTICIPANT_ONLY: {
                    if (!userSecurityContext.isAdmin() && !userSecurityContext.isCreator() && !userSecurityContext.isRestrictedVoter() && !userSecurityContext.isVoter()) break;
                    result = allVotes;
                    break;
                }
                case EVERYBODY: {
                    result = allVotes;
                }
            }
            if (result != null) break block13;
            result = Lists.newArrayList();
            if (userSecurityContext.isVoter() || userSecurityContext.isRestrictedVoter()) {
                if (userSecurityContext.isWithAccountId()) {
                    String accountId = userSecurityContext.getAccountId();
                    for (Vote vote : allVotes) {
                        if (!accountId.equals(vote.getPollAccount().getAccountId())) continue;
                        result.add(vote);
                        break;
                    }
                } else {
                    UserAccount userAccount = userSecurityContext.getUserAccount();
                    for (Vote vote : allVotes) {
                        if (!userAccount.equals(vote.getPollAccount().getUserAccount())) continue;
                        result.add(vote);
                        break;
                    }
                    if (result.isEmpty()) {
                        String userAccountEmail = userAccount.getEmail();
                        for (Vote vote : allVotes) {
                            if (!userAccountEmail.equals(vote.getPollAccount().getEmail())) continue;
                            result.add(vote);
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

    protected boolean isPollCreator(Poll poll, String accountId, UserAccount userAccount) {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkState((userAccount != null || StringUtils.isNotBlank((CharSequence)accountId) ? 1 : 0) != 0);
        boolean result = ObjectUtils.equals((Object)poll.getCreator().getAccountId(), (Object)accountId) ? true : (userAccount != null ? (userAccount.isAdministrator() ? true : ObjectUtils.equals((Object)poll.getCreator().getEmail(), (Object)userAccount.getEmail())) : false);
        return result;
    }

    protected boolean isVoterAccountId(Poll poll, String accountId, UserAccount userAccount) {
        String pollId = poll.getPollId();
        try {
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount pollAccount = dao.findVoterPollAccount(pollId, accountId, userAccount);
            return pollAccount != null;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not check voter pollAccount existence from poll '" + pollId + "'", (Throwable)e);
        }
    }

    protected boolean isRestrictAccountId(Poll poll, String accountId, UserAccount userAccount) {
        String pollId = poll.getPollId();
        try {
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount result = dao.findRestrictedPollAccount(pollId, accountId, userAccount);
            return result != null;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not check restricted voter pollAccount existence from poll '" + pollId + "'", (Throwable)e);
        }
    }

    public boolean isAccountExist(String accountId) {
        try {
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount result = dao.findByAccountId(accountId);
            return result != null;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not check pollAccount existence from account '" + accountId + "'", (Throwable)e);
        }
    }
}

