/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.base.Preconditions;
import java.sql.Driver;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Strings;
import org.chorem.pollen.persistence.PollenPersistenceConfigurationBuilder;

public class PollenPersistenceConfiguration {
    protected String schemaName;
    protected final Map<String, String> hibernateExtraConfiguration = new LinkedHashMap<String, String>();
    protected boolean initSchema = true;
    protected boolean validateSchema = true;
    protected boolean useHikariForJdbcConnectionPooling;
    protected Duration slowQueriesThreshold;
    private final Map<String, String> migrationServiceConfiguration = new HashMap<String, String>();
    private final Class<? extends Driver> jdbcDriverClass;
    private final String jdbcConnectionUrl;
    private final String jdbcConnectionUser;
    private final String jdbcConnectionPassword;

    public PollenPersistenceConfiguration(String url, String user, String password, String driverName) {
        this.jdbcConnectionUrl = url;
        this.jdbcConnectionUser = user;
        this.jdbcConnectionPassword = password;
        this.jdbcDriverClass = PollenPersistenceConfiguration.getDriverClass(driverName);
    }

    private static Class<? extends Driver> getDriverClass(String driverClassName) {
        try {
            Class<?> jdbcDriverClass = Class.forName(driverClassName);
            return jdbcDriverClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Map<String, String> getHibernateExtraConfiguration() {
        return this.hibernateExtraConfiguration;
    }

    public Map<String, String> getMigrationServiceConfiguration() {
        return this.migrationServiceConfiguration;
    }

    public boolean isInitSchema() {
        return this.initSchema;
    }

    public void setInitSchema(boolean initSchema) {
        this.initSchema = initSchema;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public boolean isUseHikariForJdbcConnectionPooling() {
        return this.useHikariForJdbcConnectionPooling;
    }

    public void setUseHikariForJdbcConnectionPooling(boolean useHikariForJdbcConnectionPooling) {
        this.useHikariForJdbcConnectionPooling = useHikariForJdbcConnectionPooling;
    }

    public Optional<Duration> getSlowQueriesThreshold() {
        return Optional.ofNullable(this.slowQueriesThreshold);
    }

    public void setSlowQueriesThreshold(Duration slowQueriesThreshold) {
        if (slowQueriesThreshold != null) {
            Preconditions.checkArgument((!slowQueriesThreshold.isNegative() ? 1 : 0) != 0, (Object)"The slowQueriesThreshold can't be negative");
        }
        this.slowQueriesThreshold = slowQueriesThreshold;
    }

    public String dangerousToString() {
        return new PollenPersistenceConfigurationBuilder().toMap(this).toString();
    }

    public String toString() {
        return Strings.CS.replace(this.dangerousToString(), this.getJdbcConnectionPassword(), "***** hidden by PollenPersistenceConfiguration#toString *****");
    }

    public Class<? extends Driver> getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcConnectionUrl;
    }

    public String getJdbcConnectionUser() {
        return this.jdbcConnectionUser;
    }

    public String getJdbcConnectionPassword() {
        return this.jdbcConnectionPassword;
    }
}

