/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataChoiceConverter;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.services.ServiceChoice;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;

public class ServiceChoiceImpl
implements ServiceChoice {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private ChoiceDAO choiceDAO = null;
    private DataChoiceConverter converter = new DataChoiceConverter();
    private static final Log log = LogFactory.getLog(ServiceChoiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createChoice(ChoiceDTO choice) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.create(new Object[0]);
            this.converter.setTransaction(transaction);
            this.converter.populateChoiceEntity(choice, choiceEntity);
            topiaId = choiceEntity.getTopiaId();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            String string = topiaId;
            return string;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            String string = "";
            return string;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    @Override
    public List<Choice> createChoices(List<ChoiceDTO> choices, String pollId, TopiaContext transaction) {
        if (choices.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<Choice> result = null;
        try {
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            this.converter.setTransaction(transaction);
            result = new ArrayList<Choice>();
            for (ChoiceDTO choice : choices) {
                Choice choiceEntity = (Choice)this.choiceDAO.create(new Object[0]);
                choice.setId(choiceEntity.getTopiaId());
                choice.setPollId(pollId);
                this.converter.populateChoiceEntity(choice, choiceEntity);
                result.add(choiceEntity);
            }
            return result;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateChoice(ChoiceDTO choiceDTO) {
        TopiaContext transaction = null;
        boolean resu = false;
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceDTO.getId());
            if (choiceEntity != null) {
                this.converter.setTransaction(transaction);
                this.converter.populateChoiceEntity(choiceDTO, choiceEntity);
                this.choiceDAO.update(choiceEntity);
                transaction.commitTransaction();
                resu = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + choiceDTO.getId()));
            }
            boolean bl = resu;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteChoice(String choiceId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceId);
            this.choiceDAO.delete(choiceEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + choiceId));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChoiceDTO findChoiceById(String choiceId) {
        TopiaContext transaction = null;
        ChoiceDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceId);
            if (choiceEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createChoiceDTO(choiceEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            ChoiceDTO choiceDTO = result;
            return choiceDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            ChoiceDTO choiceDTO = null;
            return choiceDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChoiceDTO> findChoicesByName(String choiceName, String pollId) {
        TopiaContext transaction = null;
        List<ChoiceDTO> results = null;
        List choiceEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("pollId", pollId);
            properties.put("name", choiceName);
            choiceEntities = this.choiceDAO.findAllByProperties(properties);
            this.converter.setTransaction(transaction);
            results = this.converter.createChoiceDTOs(choiceEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<ChoiceDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<ChoiceDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChoiceDTO> selectChoices(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<ChoiceDTO> results = null;
        List choiceEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(transaction);
            if (properties == null) {
                choiceEntities = this.choiceDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les choix ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                choiceEntities = this.choiceDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createChoiceDTOs(choiceEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<ChoiceDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<ChoiceDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }
}

