/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité PollType.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PollTypeDAOAbstract<E extends PollType> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)PollType.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.Poll> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Poll.class)
                            .findAllByProperties("pollType", entity);
                    for (org.chorem.pollen.business.persistence.Poll item : list) {
                        item.setPollType(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

} // PollTypeDAOAbstract
