/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Poll}.
 */
public abstract class PollAbstract extends TopiaEntityAbstract implements Poll {

    public String pollId;

    public String title;

    public String description;

    public Date beginChoiceDate;

    public Date beginDate;

    public Date endDate;

    public Integer maxChoiceNb;

    public Boolean closed;

    public Boolean choiceAddAllowed;

    public Boolean anonymousVoteAllowed;

    public Boolean anonymous;

    public Boolean publicResults;

    public Boolean continuousResults;

    public Date endChoiceDate;

    public List<Vote> vote;

    public List<Choice> choice;

    public List<Result> result;

    public PollAccount creator;

    public List<Comment> comment;

    public List<PreventRule> preventRule;

    public List<VotingList> votingList;

    public PollType pollType;

    public ChoiceType choiceType;

    public VoteCounting voteCounting;

    /**
     * Constructeur de PollAbstract par défaut.
     */
    public PollAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Poll.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Poll.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "pollId", String.class, pollId);
        visitor.visit(this, "title", String.class, title);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "beginChoiceDate", Date.class, beginChoiceDate);
        visitor.visit(this, "beginDate", Date.class, beginDate);
        visitor.visit(this, "endDate", Date.class, endDate);
        visitor.visit(this, "maxChoiceNb", Integer.class, maxChoiceNb);
        visitor.visit(this, "closed", Boolean.class, closed);
        visitor.visit(this, "choiceAddAllowed", Boolean.class, choiceAddAllowed);
        visitor.visit(this, "anonymousVoteAllowed", Boolean.class, anonymousVoteAllowed);
        visitor.visit(this, "anonymous", Boolean.class, anonymous);
        visitor.visit(this, "publicResults", Boolean.class, publicResults);
        visitor.visit(this, "continuousResults", Boolean.class, continuousResults);
        visitor.visit(this, "endChoiceDate", Date.class, endChoiceDate);
        visitor.visit(this, "vote", List.class, Vote.class, vote);
        visitor.visit(this, "choice", List.class, Choice.class, choice);
        visitor.visit(this, "result", List.class, Result.class, result);
        visitor.visit(this, "creator", PollAccount.class, creator);
        visitor.visit(this, "comment", List.class, Comment.class, comment);
        visitor.visit(this, "preventRule", List.class, PreventRule.class, preventRule);
        visitor.visit(this, "votingList", List.class, VotingList.class, votingList);
        visitor.visit(this, "pollType", PollType.class, pollType);
        visitor.visit(this, "choiceType", ChoiceType.class, choiceType);
        visitor.visit(this, "voteCounting", VoteCounting.class, voteCounting);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getVote() != null) {
              tmp.addAll(getVote());
           }
        if (getChoice() != null) {
              tmp.addAll(getChoice());
           }
        if (getResult() != null) {
              tmp.addAll(getResult());
           }
        if (getComment() != null) {
              tmp.addAll(getComment());
           }
        if (getPreventRule() != null) {
              tmp.addAll(getPreventRule());
           }
        if (getVotingList() != null) {
              tmp.addAll(getVotingList());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setPollId(String)
     */
    @Override
    public void setPollId(String value) {
        String _oldValue = this.pollId;
        fireOnPreWrite("pollId", _oldValue, value);
        this.pollId = value;
        fireOnPostWrite("pollId", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getPollId()
     */
    @Override
    public String getPollId() {
        fireOnPreRead("pollId", pollId);
        String result = this.pollId;
        fireOnPostRead("pollId", pollId);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setTitle(String)
     */
    @Override
    public void setTitle(String value) {
        String _oldValue = this.title;
        fireOnPreWrite("title", _oldValue, value);
        this.title = value;
        fireOnPostWrite("title", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getTitle()
     */
    @Override
    public String getTitle() {
        fireOnPreRead("title", title);
        String result = this.title;
        fireOnPostRead("title", title);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setDescription(String)
     */
    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getDescription()
     */
    @Override
    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setBeginChoiceDate(Date)
     */
    @Override
    public void setBeginChoiceDate(Date value) {
        Date _oldValue = this.beginChoiceDate;
        fireOnPreWrite("beginChoiceDate", _oldValue, value);
        this.beginChoiceDate = value;
        fireOnPostWrite("beginChoiceDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getBeginChoiceDate()
     */
    @Override
    public Date getBeginChoiceDate() {
        fireOnPreRead("beginChoiceDate", beginChoiceDate);
        Date result = this.beginChoiceDate;
        fireOnPostRead("beginChoiceDate", beginChoiceDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setBeginDate(Date)
     */
    @Override
    public void setBeginDate(Date value) {
        Date _oldValue = this.beginDate;
        fireOnPreWrite("beginDate", _oldValue, value);
        this.beginDate = value;
        fireOnPostWrite("beginDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getBeginDate()
     */
    @Override
    public Date getBeginDate() {
        fireOnPreRead("beginDate", beginDate);
        Date result = this.beginDate;
        fireOnPostRead("beginDate", beginDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setEndDate(Date)
     */
    @Override
    public void setEndDate(Date value) {
        Date _oldValue = this.endDate;
        fireOnPreWrite("endDate", _oldValue, value);
        this.endDate = value;
        fireOnPostWrite("endDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getEndDate()
     */
    @Override
    public Date getEndDate() {
        fireOnPreRead("endDate", endDate);
        Date result = this.endDate;
        fireOnPostRead("endDate", endDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setMaxChoiceNb(Integer)
     */
    @Override
    public void setMaxChoiceNb(Integer value) {
        Integer _oldValue = this.maxChoiceNb;
        fireOnPreWrite("maxChoiceNb", _oldValue, value);
        this.maxChoiceNb = value;
        fireOnPostWrite("maxChoiceNb", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getMaxChoiceNb()
     */
    @Override
    public Integer getMaxChoiceNb() {
        fireOnPreRead("maxChoiceNb", maxChoiceNb);
        Integer result = this.maxChoiceNb;
        fireOnPostRead("maxChoiceNb", maxChoiceNb);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setClosed(Boolean)
     */
    @Override
    public void setClosed(Boolean value) {
        Boolean _oldValue = this.closed;
        fireOnPreWrite("closed", _oldValue, value);
        this.closed = value;
        fireOnPostWrite("closed", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getClosed()
     */
    @Override
    public Boolean getClosed() {
        fireOnPreRead("closed", closed);
        Boolean result = this.closed;
        fireOnPostRead("closed", closed);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setChoiceAddAllowed(Boolean)
     */
    @Override
    public void setChoiceAddAllowed(Boolean value) {
        Boolean _oldValue = this.choiceAddAllowed;
        fireOnPreWrite("choiceAddAllowed", _oldValue, value);
        this.choiceAddAllowed = value;
        fireOnPostWrite("choiceAddAllowed", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getChoiceAddAllowed()
     */
    @Override
    public Boolean getChoiceAddAllowed() {
        fireOnPreRead("choiceAddAllowed", choiceAddAllowed);
        Boolean result = this.choiceAddAllowed;
        fireOnPostRead("choiceAddAllowed", choiceAddAllowed);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setAnonymousVoteAllowed(Boolean)
     */
    @Override
    public void setAnonymousVoteAllowed(Boolean value) {
        Boolean _oldValue = this.anonymousVoteAllowed;
        fireOnPreWrite("anonymousVoteAllowed", _oldValue, value);
        this.anonymousVoteAllowed = value;
        fireOnPostWrite("anonymousVoteAllowed", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getAnonymousVoteAllowed()
     */
    @Override
    public Boolean getAnonymousVoteAllowed() {
        fireOnPreRead("anonymousVoteAllowed", anonymousVoteAllowed);
        Boolean result = this.anonymousVoteAllowed;
        fireOnPostRead("anonymousVoteAllowed", anonymousVoteAllowed);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setAnonymous(Boolean)
     */
    @Override
    public void setAnonymous(Boolean value) {
        Boolean _oldValue = this.anonymous;
        fireOnPreWrite("anonymous", _oldValue, value);
        this.anonymous = value;
        fireOnPostWrite("anonymous", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getAnonymous()
     */
    @Override
    public Boolean getAnonymous() {
        fireOnPreRead("anonymous", anonymous);
        Boolean result = this.anonymous;
        fireOnPostRead("anonymous", anonymous);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setPublicResults(Boolean)
     */
    @Override
    public void setPublicResults(Boolean value) {
        Boolean _oldValue = this.publicResults;
        fireOnPreWrite("publicResults", _oldValue, value);
        this.publicResults = value;
        fireOnPostWrite("publicResults", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getPublicResults()
     */
    @Override
    public Boolean getPublicResults() {
        fireOnPreRead("publicResults", publicResults);
        Boolean result = this.publicResults;
        fireOnPostRead("publicResults", publicResults);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setContinuousResults(Boolean)
     */
    @Override
    public void setContinuousResults(Boolean value) {
        Boolean _oldValue = this.continuousResults;
        fireOnPreWrite("continuousResults", _oldValue, value);
        this.continuousResults = value;
        fireOnPostWrite("continuousResults", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getContinuousResults()
     */
    @Override
    public Boolean getContinuousResults() {
        fireOnPreRead("continuousResults", continuousResults);
        Boolean result = this.continuousResults;
        fireOnPostRead("continuousResults", continuousResults);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setEndChoiceDate(Date)
     */
    @Override
    public void setEndChoiceDate(Date value) {
        Date _oldValue = this.endChoiceDate;
        fireOnPreWrite("endChoiceDate", _oldValue, value);
        this.endChoiceDate = value;
        fireOnPostWrite("endChoiceDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getEndChoiceDate()
     */
    @Override
    public Date getEndChoiceDate() {
        fireOnPreRead("endChoiceDate", endChoiceDate);
        Date result = this.endChoiceDate;
        fireOnPostRead("endChoiceDate", endChoiceDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#addVote(Vote)
     */
    @Override
    public void addVote(Vote vote) {
        fireOnPreWrite("vote", null, vote);
        if (this.vote == null) {
            this.vote = new ArrayList<Vote>();
        }
        vote.setPoll(this);
        this.vote.add(vote);
        fireOnPostWrite("vote", this.vote.size(), null, vote);
    }

    /* (non-Javadoc)
     * @see Poll#addAllVote(List<Vote>)
     */
    @Override
    public void addAllVote(List<Vote> values) {
        if (values == null) {
            return;
        }
        for (Vote item : values) {
            addVote(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getVoteByTopiaId(String)
     */
    @Override
    public Vote getVoteByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(vote, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setVote(List<Vote>)
     */
    @Override
    public void setVote(List<Vote> values) {
        List<Vote> _oldValue = vote;
        fireOnPreWrite("vote", _oldValue, values);
        vote = values;
        fireOnPostWrite("vote", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removeVote(Vote)
     */
    @Override
    public void removeVote(Vote value) {
        fireOnPreWrite("vote", value, null);
        if ((this.vote == null) || (!this.vote.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("vote", this.vote.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearVote()
     */
    @Override
    public void clearVote() {
        if (this.vote == null) {
            return;
        }
        for (Vote item : this.vote) {
            item.setPoll(null);
        }
        List<Vote> _oldValue = new ArrayList<Vote>(this.vote);
        fireOnPreWrite("vote", _oldValue, this.vote);
        this.vote.clear();
        fireOnPostWrite("vote", _oldValue, this.vote);
    }

    /* (non-Javadoc)
     * @see Poll#getVote()
     */
    @Override
    public List<Vote> getVote() {
        return vote;
    }

    /* (non-Javadoc)
     * @see Poll#sizeVote()
     */
    @Override
    public int sizeVote() {
        if (vote == null) {
            return 0;
        }
        return vote.size();
    }

    /* (non-Javadoc)
     * @see Poll#isVoteEmpty()
     */
    @Override
    public boolean isVoteEmpty() {
        int size = sizeVote();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#addChoice(Choice)
     */
    @Override
    public void addChoice(Choice choice) {
        fireOnPreWrite("choice", null, choice);
        if (this.choice == null) {
            this.choice = new ArrayList<Choice>();
        }
        choice.setPoll(this);
        this.choice.add(choice);
        fireOnPostWrite("choice", this.choice.size(), null, choice);
    }

    /* (non-Javadoc)
     * @see Poll#addAllChoice(List<Choice>)
     */
    @Override
    public void addAllChoice(List<Choice> values) {
        if (values == null) {
            return;
        }
        for (Choice item : values) {
            addChoice(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getChoiceByTopiaId(String)
     */
    @Override
    public Choice getChoiceByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(choice, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setChoice(List<Choice>)
     */
    @Override
    public void setChoice(List<Choice> values) {
        List<Choice> _oldValue = choice;
        fireOnPreWrite("choice", _oldValue, values);
        choice = values;
        fireOnPostWrite("choice", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removeChoice(Choice)
     */
    @Override
    public void removeChoice(Choice value) {
        fireOnPreWrite("choice", value, null);
        if ((this.choice == null) || (!this.choice.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("choice", this.choice.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearChoice()
     */
    @Override
    public void clearChoice() {
        if (this.choice == null) {
            return;
        }
        for (Choice item : this.choice) {
            item.setPoll(null);
        }
        List<Choice> _oldValue = new ArrayList<Choice>(this.choice);
        fireOnPreWrite("choice", _oldValue, this.choice);
        this.choice.clear();
        fireOnPostWrite("choice", _oldValue, this.choice);
    }

    /* (non-Javadoc)
     * @see Poll#getChoice()
     */
    @Override
    public List<Choice> getChoice() {
        return choice;
    }

    /* (non-Javadoc)
     * @see Poll#sizeChoice()
     */
    @Override
    public int sizeChoice() {
        if (choice == null) {
            return 0;
        }
        return choice.size();
    }

    /* (non-Javadoc)
     * @see Poll#isChoiceEmpty()
     */
    @Override
    public boolean isChoiceEmpty() {
        int size = sizeChoice();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#addResult(Result)
     */
    @Override
    public void addResult(Result result) {
        fireOnPreWrite("result", null, result);
        if (this.result == null) {
            this.result = new ArrayList<Result>();
        }
        result.setPoll(this);
        this.result.add(result);
        fireOnPostWrite("result", this.result.size(), null, result);
    }

    /* (non-Javadoc)
     * @see Poll#addAllResult(List<Result>)
     */
    @Override
    public void addAllResult(List<Result> values) {
        if (values == null) {
            return;
        }
        for (Result item : values) {
            addResult(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getResultByTopiaId(String)
     */
    @Override
    public Result getResultByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(result, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setResult(List<Result>)
     */
    @Override
    public void setResult(List<Result> values) {
        List<Result> _oldValue = result;
        fireOnPreWrite("result", _oldValue, values);
        result = values;
        fireOnPostWrite("result", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removeResult(Result)
     */
    @Override
    public void removeResult(Result value) {
        fireOnPreWrite("result", value, null);
        if ((this.result == null) || (!this.result.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("result", this.result.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearResult()
     */
    @Override
    public void clearResult() {
        if (this.result == null) {
            return;
        }
        for (Result item : this.result) {
            item.setPoll(null);
        }
        List<Result> _oldValue = new ArrayList<Result>(this.result);
        fireOnPreWrite("result", _oldValue, this.result);
        this.result.clear();
        fireOnPostWrite("result", _oldValue, this.result);
    }

    /* (non-Javadoc)
     * @see Poll#getResult()
     */
    @Override
    public List<Result> getResult() {
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#sizeResult()
     */
    @Override
    public int sizeResult() {
        if (result == null) {
            return 0;
        }
        return result.size();
    }

    /* (non-Javadoc)
     * @see Poll#isResultEmpty()
     */
    @Override
    public boolean isResultEmpty() {
        int size = sizeResult();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#setCreator(PollAccount)
     */
    @Override
    public void setCreator(PollAccount value) {
        PollAccount _oldValue = this.creator;
        fireOnPreWrite("creator", _oldValue, value);
        this.creator = value;
        fireOnPostWrite("creator", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getCreator()
     */
    @Override
    public PollAccount getCreator() {
        fireOnPreRead("creator", creator);
        PollAccount result = this.creator;
        fireOnPostRead("creator", creator);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#addComment(Comment)
     */
    @Override
    public void addComment(Comment comment) {
        fireOnPreWrite("comment", null, comment);
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        comment.setPoll(this);
        this.comment.add(comment);
        fireOnPostWrite("comment", this.comment.size(), null, comment);
    }

    /* (non-Javadoc)
     * @see Poll#addAllComment(List<Comment>)
     */
    @Override
    public void addAllComment(List<Comment> values) {
        if (values == null) {
            return;
        }
        for (Comment item : values) {
            addComment(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getCommentByTopiaId(String)
     */
    @Override
    public Comment getCommentByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(comment, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setComment(List<Comment>)
     */
    @Override
    public void setComment(List<Comment> values) {
        List<Comment> _oldValue = comment;
        fireOnPreWrite("comment", _oldValue, values);
        comment = values;
        fireOnPostWrite("comment", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removeComment(Comment)
     */
    @Override
    public void removeComment(Comment value) {
        fireOnPreWrite("comment", value, null);
        if ((this.comment == null) || (!this.comment.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("comment", this.comment.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearComment()
     */
    @Override
    public void clearComment() {
        if (this.comment == null) {
            return;
        }
        for (Comment item : this.comment) {
            item.setPoll(null);
        }
        List<Comment> _oldValue = new ArrayList<Comment>(this.comment);
        fireOnPreWrite("comment", _oldValue, this.comment);
        this.comment.clear();
        fireOnPostWrite("comment", _oldValue, this.comment);
    }

    /* (non-Javadoc)
     * @see Poll#getComment()
     */
    @Override
    public List<Comment> getComment() {
        return comment;
    }

    /* (non-Javadoc)
     * @see Poll#sizeComment()
     */
    @Override
    public int sizeComment() {
        if (comment == null) {
            return 0;
        }
        return comment.size();
    }

    /* (non-Javadoc)
     * @see Poll#isCommentEmpty()
     */
    @Override
    public boolean isCommentEmpty() {
        int size = sizeComment();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#addPreventRule(PreventRule)
     */
    @Override
    public void addPreventRule(PreventRule preventRule) {
        fireOnPreWrite("preventRule", null, preventRule);
        if (this.preventRule == null) {
            this.preventRule = new ArrayList<PreventRule>();
        }
        preventRule.setPoll(this);
        this.preventRule.add(preventRule);
        fireOnPostWrite("preventRule", this.preventRule.size(), null, preventRule);
    }

    /* (non-Javadoc)
     * @see Poll#addAllPreventRule(List<PreventRule>)
     */
    @Override
    public void addAllPreventRule(List<PreventRule> values) {
        if (values == null) {
            return;
        }
        for (PreventRule item : values) {
            addPreventRule(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getPreventRuleByTopiaId(String)
     */
    @Override
    public PreventRule getPreventRuleByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(preventRule, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setPreventRule(List<PreventRule>)
     */
    @Override
    public void setPreventRule(List<PreventRule> values) {
        List<PreventRule> _oldValue = preventRule;
        fireOnPreWrite("preventRule", _oldValue, values);
        preventRule = values;
        fireOnPostWrite("preventRule", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removePreventRule(PreventRule)
     */
    @Override
    public void removePreventRule(PreventRule value) {
        fireOnPreWrite("preventRule", value, null);
        if ((this.preventRule == null) || (!this.preventRule.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("preventRule", this.preventRule.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearPreventRule()
     */
    @Override
    public void clearPreventRule() {
        if (this.preventRule == null) {
            return;
        }
        for (PreventRule item : this.preventRule) {
            item.setPoll(null);
        }
        List<PreventRule> _oldValue = new ArrayList<PreventRule>(this.preventRule);
        fireOnPreWrite("preventRule", _oldValue, this.preventRule);
        this.preventRule.clear();
        fireOnPostWrite("preventRule", _oldValue, this.preventRule);
    }

    /* (non-Javadoc)
     * @see Poll#getPreventRule()
     */
    @Override
    public List<PreventRule> getPreventRule() {
        return preventRule;
    }

    /* (non-Javadoc)
     * @see Poll#sizePreventRule()
     */
    @Override
    public int sizePreventRule() {
        if (preventRule == null) {
            return 0;
        }
        return preventRule.size();
    }

    /* (non-Javadoc)
     * @see Poll#isPreventRuleEmpty()
     */
    @Override
    public boolean isPreventRuleEmpty() {
        int size = sizePreventRule();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#addVotingList(VotingList)
     */
    @Override
    public void addVotingList(VotingList votingList) {
        fireOnPreWrite("votingList", null, votingList);
        if (this.votingList == null) {
            this.votingList = new ArrayList<VotingList>();
        }
        votingList.setPoll(this);
        this.votingList.add(votingList);
        fireOnPostWrite("votingList", this.votingList.size(), null, votingList);
    }

    /* (non-Javadoc)
     * @see Poll#addAllVotingList(List<VotingList>)
     */
    @Override
    public void addAllVotingList(List<VotingList> values) {
        if (values == null) {
            return;
        }
        for (VotingList item : values) {
            addVotingList(item);
        }
    }

    /* (non-Javadoc)
     * @see Poll#getVotingListByTopiaId(String)
     */
    @Override
    public VotingList getVotingListByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(votingList, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Poll#setVotingList(List<VotingList>)
     */
    @Override
    public void setVotingList(List<VotingList> values) {
        List<VotingList> _oldValue = votingList;
        fireOnPreWrite("votingList", _oldValue, values);
        votingList = values;
        fireOnPostWrite("votingList", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Poll#removeVotingList(VotingList)
     */
    @Override
    public void removeVotingList(VotingList value) {
        fireOnPreWrite("votingList", value, null);
        if ((this.votingList == null) || (!this.votingList.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPoll(null);
        fireOnPostWrite("votingList", this.votingList.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Poll#clearVotingList()
     */
    @Override
    public void clearVotingList() {
        if (this.votingList == null) {
            return;
        }
        for (VotingList item : this.votingList) {
            item.setPoll(null);
        }
        List<VotingList> _oldValue = new ArrayList<VotingList>(this.votingList);
        fireOnPreWrite("votingList", _oldValue, this.votingList);
        this.votingList.clear();
        fireOnPostWrite("votingList", _oldValue, this.votingList);
    }

    /* (non-Javadoc)
     * @see Poll#getVotingList()
     */
    @Override
    public List<VotingList> getVotingList() {
        return votingList;
    }

    /* (non-Javadoc)
     * @see Poll#sizeVotingList()
     */
    @Override
    public int sizeVotingList() {
        if (votingList == null) {
            return 0;
        }
        return votingList.size();
    }

    /* (non-Javadoc)
     * @see Poll#isVotingListEmpty()
     */
    @Override
    public boolean isVotingListEmpty() {
        int size = sizeVotingList();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Poll#setPollType(PollType)
     */
    @Override
    public void setPollType(PollType value) {
        PollType _oldValue = this.pollType;
        fireOnPreWrite("pollType", _oldValue, value);
        this.pollType = value;
        fireOnPostWrite("pollType", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getPollType()
     */
    @Override
    public PollType getPollType() {
        fireOnPreRead("pollType", pollType);
        PollType result = this.pollType;
        fireOnPostRead("pollType", pollType);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setChoiceType(ChoiceType)
     */
    @Override
    public void setChoiceType(ChoiceType value) {
        ChoiceType _oldValue = this.choiceType;
        fireOnPreWrite("choiceType", _oldValue, value);
        this.choiceType = value;
        fireOnPostWrite("choiceType", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getChoiceType()
     */
    @Override
    public ChoiceType getChoiceType() {
        fireOnPreRead("choiceType", choiceType);
        ChoiceType result = this.choiceType;
        fireOnPostRead("choiceType", choiceType);
        return result;
    }

    /* (non-Javadoc)
     * @see Poll#setVoteCounting(VoteCounting)
     */
    @Override
    public void setVoteCounting(VoteCounting value) {
        VoteCounting _oldValue = this.voteCounting;
        fireOnPreWrite("voteCounting", _oldValue, value);
        this.voteCounting = value;
        fireOnPostWrite("voteCounting", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Poll#getVoteCounting()
     */
    @Override
    public VoteCounting getVoteCounting() {
        fireOnPreRead("voteCounting", voteCounting);
        VoteCounting result = this.voteCounting;
        fireOnPostRead("voteCounting", voteCounting);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("pollId", this.pollId).
            append("title", this.title).
            append("description", this.description).
            append("beginChoiceDate", this.beginChoiceDate).
            append("beginDate", this.beginDate).
            append("endDate", this.endDate).
            append("maxChoiceNb", this.maxChoiceNb).
            append("closed", this.closed).
            append("choiceAddAllowed", this.choiceAddAllowed).
            append("anonymousVoteAllowed", this.anonymousVoteAllowed).
            append("anonymous", this.anonymous).
            append("publicResults", this.publicResults).
            append("continuousResults", this.continuousResults).
            append("endChoiceDate", this.endChoiceDate).
            append("pollType", this.pollType).
            append("choiceType", this.choiceType).
            append("voteCounting", this.voteCounting).
         toString();
        return result;
    }
        
} //PollAbstract
