/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name","description"},
  boolFields={"validate"}
)        
public interface Choice extends TopiaEntity {

    public static final String NAME = "name";

    public static final String DESCRIPTION = "description";

    public static final String VALIDATE = "validate";

    public static final String VOTE_VOTE_TO_CHOICE = "voteVoteToChoice";

    public static final String POLL = "poll";

    /**
     * @param name La valeur de l'attribut name à positionner.
     */
    public void setName(java.lang.String name);

    /**
     * @return La valeur de l'attribut name.
     */
    public java.lang.String getName();

    /**
     * @param description La valeur de l'attribut description à positionner.
     */
    public void setDescription(java.lang.String description);

    /**
     * @return La valeur de l'attribut description.
     */
    public java.lang.String getDescription();

    /**
     * @param validate La valeur de l'attribut validate à positionner.
     */
    public void setValidate(java.lang.Boolean validate);

    /**
     * @return La valeur de l'attribut validate.
     */
    public java.lang.Boolean getValidate();

    /**
     * @param voteToChoice L'instance de VoteToChoice à ajouter.
     */
    public void addVoteVoteToChoice(org.chorem.pollen.business.persistence.VoteToChoice voteToChoice);

    /**
     * @param voteToChoice Les instances de VoteToChoice à ajouter.
     */
    public void addAllVoteVoteToChoice(java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> voteToChoice);

    /**
     * @param voteToChoice La Collection de VoteToChoice à positionner.
     */
    public void setVoteVoteToChoice(java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> voteToChoice);

    /**
     * @param voteToChoice L'instance de VoteToChoice à retirer.
     */
    public void removeVoteVoteToChoice(org.chorem.pollen.business.persistence.VoteToChoice voteToChoice);

    /**
     * Vide la Collection de VoteToChoice.
     */
    public void clearVoteVoteToChoice();

    /**
     * @return La liste des attributs VoteToChoice.
     */
    public java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> getVoteVoteToChoice();

    /**
     * Recupère l'attribut vote à partir de son topiaId.
     *
     * @param topiaId le topia id de l'attribut recherchée
     * 
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.VoteToChoice getVoteVoteToChoiceByTopiaId(String topiaId);

    /**
     * @return L'attribut VoteToChoice associé à la valeur <code>value</code> de l'attribut vote.
     */
    public org.chorem.pollen.business.persistence.VoteToChoice getVoteVoteToChoice(org.chorem.pollen.business.persistence.Vote value);

    /**
     * @return Le nombre d'éléments de la collection vote.
     */
    public int sizeVoteVoteToChoice();
  
    /**
     * @return <code>true</code> si la collection voteVoteToChoice est vide.
     */
    public boolean isVoteVoteToChoiceEmpty();
    /**
     * @param poll La valeur de l'attribut poll à positionner.
     */
    public void setPoll(org.chorem.pollen.business.persistence.Poll poll);

    /**
     * @return La valeur de l'attribut poll.
     */
    public org.chorem.pollen.business.persistence.Poll getPoll();

} //Choice
