/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPollConverter;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.services.ServiceChoiceImpl;
import org.chorem.pollen.business.services.ServiceCommentImpl;
import org.chorem.pollen.business.services.ServiceListImpl;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccountImpl;
import org.chorem.pollen.business.services.ServicePreventRuleImpl;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;

public class ServicePollImpl
implements ServicePoll {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private PollDAO pollDAO = null;
    private DataPollConverter converter = new DataPollConverter();
    private static final Log log = LogFactory.getLog(ServicePollImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createPoll(PollDTO pollDTO) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Poll pollEntity = (Poll)this.pollDAO.create(new Object[0]);
            String id = UUID.randomUUID().toString();
            pollDTO.setPollId(id.replaceAll("-", ""));
            this.converter.setTransaction(transaction);
            this.converter.populatePollEntity(pollDTO, pollEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            PollAccount pollAccountEntity = spa.createPollAccount(pollDTO.getCreatorId(), pollDTO.getCreatorEmail(), pollDTO.getUserId());
            pollEntity.setCreator(pollAccountEntity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("userId: " + pollDTO.getUserId() + ", pollAccountEntity created: " + (pollAccountEntity != null)));
            }
            topiaId = pollEntity.getTopiaId();
            ServiceChoiceImpl sChoice = new ServiceChoiceImpl();
            pollEntity.setChoice(sChoice.createChoices(pollDTO.getChoiceDTOs(), topiaId, transaction));
            ServiceCommentImpl sComment = new ServiceCommentImpl();
            pollEntity.setComment(sComment.createComments(pollDTO.getCommentDTOs(), topiaId, transaction));
            ServiceListImpl sList = new ServiceListImpl();
            pollEntity.setVotingList(sList.createVotingLists(pollDTO.getVotingListDTOs(), topiaId, transaction));
            ServicePreventRuleImpl sPreventRule = new ServicePreventRuleImpl();
            pollEntity.setPreventRule(sPreventRule.createPreventRules(pollDTO.getPreventRuleDTOs(), topiaId, transaction));
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("creator after creation: " + pollEntity.getCreator()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            String string = topiaId;
            return string;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            String string = "";
            return string;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePoll(PollDTO pollDTO) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollDTO.getId());
            this.converter.setTransaction(transaction);
            this.converter.populatePollEntity(pollDTO, pollEntity);
            this.converter.persistChoices(pollDTO, pollEntity);
            this.converter.persistPreventRules(pollDTO, pollEntity);
            this.pollDAO.update(pollEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + pollDTO.getId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePoll(String pollId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            this.pollDAO.delete(pollEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + pollId));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollDTO findPollById(String pollId) {
        TopiaContext transaction = null;
        PollDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            if (pollEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createPollDTO(pollEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            PollDTO pollDTO = result;
            return pollDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            PollDTO pollDTO = null;
            return pollDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollDTO findPollByPollId(String pollId) {
        TopiaContext transaction = null;
        PollDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Object pollEntity = this.pollDAO.findByPollId(pollId);
            if (pollEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createPollDTO((Poll)pollEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            PollDTO pollDTO = result;
            return pollDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            PollDTO pollDTO = null;
            return pollDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> findPollsByName(String pollName) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        List<Poll> pollEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            pollEntities = this.pollDAO.findAllByTitle(pollName);
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(pollEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> findPollsByUser(String userId) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            ArrayList<Poll> pollEntities = new ArrayList<Poll>();
            for (PollAccount pollAccount : user.getPollAccount()) {
                pollEntities.addAll(pollAccount.getPollsCreated());
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(pollEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> findParticipatedPolls(String userId) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            HashSet<Poll> pollEntities = new HashSet<Poll>();
            for (PollAccount pollAccount : user.getPollAccount()) {
                for (Vote vote : pollAccount.getVote()) {
                    pollEntities.add(vote.getPoll());
                }
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(new ArrayList<Poll>(pollEntities));
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> findInvitedPolls(String userId) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            List polls = this.pollDAO.findAll();
            HashSet<Poll> pollEntities = new HashSet<Poll>();
            for (Poll poll : polls) {
                for (VotingList votingList : poll.getVotingList()) {
                    for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
                        PollAccount pollAccount;
                        if (personToList.getHasVoted().booleanValue() || (pollAccount = personToList.getPollAccount()) == null || pollAccount.getEmail() == null || !pollAccount.getEmail().equals(user.getEmail())) continue;
                        pollEntities.add(poll);
                    }
                }
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(new ArrayList<Poll>(pollEntities));
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> findRunningPolls(boolean withEndDate) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        List pollEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            pollEntities = withEndDate ? transaction.find("from " + Poll.class.getName() + " as poll where (poll.endDate is not null and poll.endDate > current_timestamp())" + " and (poll.beginDate is null or poll.beginDate < current_timestamp())", new Object[0]) : transaction.find("from " + Poll.class.getName() + " as poll where (poll.endDate is null or poll.endDate > current_timestamp())" + " and (poll.beginDate is null or poll.beginDate < current_timestamp())", new Object[0]);
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(pollEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollDTO> selectPolls(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<PollDTO> results = null;
        List pollEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            if (properties == null) {
                pollEntities = this.pollDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les sondages ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                pollEntities = this.pollDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPollDTOs(pollEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVoteToPoll(String pollId, String voteId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollDAO = PollenModelDAOHelper.getPollDAO(transaction);
            Poll pollEntity = (Poll)this.pollDAO.findByTopiaId(pollId);
            VoteDAO voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)voteDAO.findByTopiaId(voteId);
            if (log.isDebugEnabled()) {
                log.debug((Object)(pollEntity + " " + voteEntity));
            }
            pollEntity.addVote(voteEntity);
            pollEntity.update();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + pollId));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }
}

