/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link PersonToList}.
 */
public abstract class PersonToListAbstract extends TopiaEntityAbstract implements PersonToList {

    public Double weight;

    public Boolean hasVoted;

    public VotingList votingList;

    public PollAccount pollAccount;

    /**
     * Constructeur de PersonToListAbstract par défaut.
     */
    public PersonToListAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PersonToList.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PersonToList.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "weight", Double.class, weight);
        visitor.visit(this, "hasVoted", Boolean.class, hasVoted);
        visitor.visit(this, "votingList", VotingList.class, votingList);
        visitor.visit(this, "pollAccount", PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see PersonToList#setWeight(Double)
     */
    @Override
    public void setWeight(Double value) {
        Double _oldValue = this.weight;
        fireOnPreWrite("weight", _oldValue, value);
        this.weight = value;
        fireOnPostWrite("weight", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PersonToList#getWeight()
     */
    @Override
    public Double getWeight() {
        fireOnPreRead("weight", weight);
        Double result = this.weight;
        fireOnPostRead("weight", weight);
        return result;
    }

    /* (non-Javadoc)
     * @see PersonToList#setHasVoted(Boolean)
     */
    @Override
    public void setHasVoted(Boolean value) {
        Boolean _oldValue = this.hasVoted;
        fireOnPreWrite("hasVoted", _oldValue, value);
        this.hasVoted = value;
        fireOnPostWrite("hasVoted", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PersonToList#getHasVoted()
     */
    @Override
    public Boolean getHasVoted() {
        fireOnPreRead("hasVoted", hasVoted);
        Boolean result = this.hasVoted;
        fireOnPostRead("hasVoted", hasVoted);
        return result;
    }

    /**
     * @param value La valeur de l'attribut votingList à positionner.
     */
    @Override
    public void setVotingList(VotingList value) {
        VotingList _oldValue = this.votingList;
        fireOnPreWrite("votingList", _oldValue, value);
        this.votingList = value;
        fireOnPostWrite("votingList", _oldValue, value);
    }

    /**
     * @return La valeur de l'attribut votingList.
     */
    @Override
    public VotingList getVotingList() {
        return votingList;
    }

    /**
     * @param value La valeur de l'attribut pollAccount à positionner.
     */
    @Override
    public void setPollAccount(PollAccount value) {
        PollAccount _oldValue = this.pollAccount;
        fireOnPreWrite("pollAccount", _oldValue, value);
        this.pollAccount = value;
        fireOnPostWrite("pollAccount", _oldValue, value);
    }

    /**
     * @return La valeur de l'attribut pollAccount.
     */
    @Override
    public PollAccount getPollAccount() {
        return pollAccount;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("weight", this.weight).
            append("hasVoted", this.hasVoted).
         toString();
        return result;
    }
        
} //PersonToListAbstract
