/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.PreventRule;
import org.nuiton.topia.TopiaException;

/**
 * Gestion de la conversion des dtos règle en entité et vice-versa.
 *
 * @author rannou
 * @version $Id: DataPreventRuleConverter.java 2615 2009-07-01 13:47:45Z nrannou
 *          $
 */
public class DataPreventRuleConverter extends DataConverter {

    /**
     * Création d'une entité à partir d'un dto règle.
     *
     * @param preventRuleDTO le dto de la règle
     * @param ePreventRule l'entité de la règle
     */
    public void populatePreventRuleEntity(PreventRuleDTO preventRuleDTO,
            PreventRule ePreventRule) throws TopiaException {
        ePreventRule.setScope(preventRuleDTO.getScope());
        ePreventRule.setSensibility(preventRuleDTO.getSensibility());
        ePreventRule.setActive(preventRuleDTO.isActive());
        ePreventRule.setOneTime(preventRuleDTO.isOneTime());
        ePreventRule.setRepeated(preventRuleDTO.isRepeated());
        ePreventRule.setMethod(preventRuleDTO.getMethod());

        if (preventRuleDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper
                    .getPollDAO(super.transaction);
            Poll pollEntity = pollDAO.findByTopiaId(preventRuleDTO.getPollId());
            ePreventRule.setPoll(pollEntity);
        }
    }

    /**
     * Création d'un dto à partir d'une entité règle.
     *
     * @param preventRule l'entité de la règle
     * @return Le dto règle créé
     */
    public PreventRuleDTO createPreventRuleDTO(PreventRule preventRule) {
        PreventRuleDTO preventRuleDTO = new PreventRuleDTO();
        preventRuleDTO.setId(preventRule.getTopiaId());
        preventRuleDTO.setScope(preventRule.getScope());
        preventRuleDTO.setSensibility(preventRule.getSensibility());
        preventRuleDTO.setActive(preventRule.getActive());
        preventRuleDTO.setOneTime(preventRule.getOneTime());
        preventRuleDTO.setRepeated(preventRule.getRepeated());
        preventRuleDTO.setMethod(preventRule.getMethod());

        if (preventRule.getPoll() != null) {
            preventRuleDTO.setPollId(preventRule.getPoll().getTopiaId());
        }

        return preventRuleDTO;
    }

    /**
     * Retourne une liste de dtos règle à partir d'une collection d'entités.
     *
     * @param cPreventRules collection des entités règle
     * @return la liste des dtos règle
     */
    public List<PreventRuleDTO> createPreventRuleDTOs(
            Collection<PreventRule> cPreventRules) {
        List<PreventRuleDTO> results = new ArrayList<PreventRuleDTO>();
        PreventRuleDTO dto;
        for (PreventRule r : cPreventRules) {
            dto = this.createPreventRuleDTO(r);
            results.add(dto);
        }
        return results;
    }
}
