package org.chorem.android.saymytexts;

/*
 * #%L
 * Say My Texts
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.RemoteViews;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SayMyTextsWidgetProvider extends AppWidgetProvider {

    private static final String TAG = "SayMyTextsWidgetProvider";

    protected static final String CLICK_ACTION = "org.chorem.android.saymytexts.action.APPWIDGET_CLICKED";

    @Override
    public void onUpdate(final Context context, final AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        final int N = appWidgetIds.length;

        // Perform this loop procedure for each App Widget that belongs to this provider
        for (int i = 0; i < N; i++) {
            final int appWidgetId = appWidgetIds[i];

            // Create an Intent to call this onReceive method
            Intent intent = new Intent(context, getClass());
            intent.setAction(CLICK_ACTION);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, intent, 0);

            // Get the layout for the App Widget and attach an on-click listener
            // to the button
            RemoteViews views = updateButtonState(context);
            views.setOnClickPendingIntent(R.id.say_my_texts_widget, pendingIntent);

            PreferenceManager.getDefaultSharedPreferences(context)
                    .registerOnSharedPreferenceChangeListener(new SharedPreferences.OnSharedPreferenceChangeListener() {
                        @Override
                        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                            String enableReadingKey = context.getString(R.string.preference_enable_reading_key);
                            if (key.equals(enableReadingKey)) {
                                RemoteViews views = updateButtonState(context);
                                appWidgetManager.updateAppWidget(appWidgetId, views);
                            }
                        }
                    });

            // Tell the AppWidgetManager to perform an update on the current app widget
            appWidgetManager.updateAppWidget(appWidgetId, views);
        }
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        super.onReceive(context, intent);
        Log.d(TAG, "on receive " + intent.getAction());
        if (CLICK_ACTION.equals(intent.getAction())) {
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(context);
            String key = context.getString(R.string.preference_enable_reading_key);
            boolean enabled = sharedPref.getBoolean(key, true);
            Log.d(TAG, "enabled " + enabled);
            sharedPref.edit().putBoolean(key, !enabled).commit();
        }
    }

    protected RemoteViews updateButtonState(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(context);
        String key = context.getString(R.string.preference_enable_reading_key);

        boolean enabled = sharedPreferences.getBoolean(key, true);
        int drawableId = enabled ?
                android.R.drawable.button_onoff_indicator_on :
                android.R.drawable.button_onoff_indicator_off;

        RemoteViews views = new RemoteViews(context.getPackageName(), R.layout.say_my_texts_widget);
        views.setImageViewResource(R.id.say_my_texts_widget_onoff_icon, drawableId);

        return views;
    }
}
