// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nppc;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nppc.*;


/**
 * Provides contour (boundary) geometry info of uniquely labeled pixel regions returned 
 * by nppiCompressedMarkerLabelsUFInfo function in host memory in counterclockwise order relative to contour interiors. 
 */

@Properties(inherit = org.bytedeco.cuda.presets.nppc.class)
public class NppiContourPixelGeometryInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NppiContourPixelGeometryInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NppiContourPixelGeometryInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NppiContourPixelGeometryInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NppiContourPixelGeometryInfo position(long position) {
        return (NppiContourPixelGeometryInfo)super.position(position);
    }
    @Override public NppiContourPixelGeometryInfo getPointer(long i) {
        return new NppiContourPixelGeometryInfo((Pointer)this).offsetAddress(i);
    }

    /** image geometry X and Y location in requested output order */
    public native @ByRef NppiPoint oContourOrderedGeometryLocation(); public native NppiContourPixelGeometryInfo oContourOrderedGeometryLocation(NppiPoint setter);
    /** image geometry X and Y location of previous contour pixel */
    public native @ByRef NppiPoint oContourPrevPixelLocation(); public native NppiContourPixelGeometryInfo oContourPrevPixelLocation(NppiPoint setter);
    /** image geometry X and Y location of center contour pixel */
    public native @ByRef NppiPoint oContourCenterPixelLocation(); public native NppiContourPixelGeometryInfo oContourCenterPixelLocation(NppiPoint setter);
    /** image geometry X and Y location of next contour pixel */
    public native @ByRef NppiPoint oContourNextPixelLocation(); public native NppiContourPixelGeometryInfo oContourNextPixelLocation(NppiPoint setter);
    /** contour pixel counterclockwise order index in geometry list */
    public native @Cast("Npp32s") int nOrderIndex(); public native NppiContourPixelGeometryInfo nOrderIndex(int setter);
    /** contour pixel clockwise order index in geometry list */
    public native @Cast("Npp32s") int nReverseOrderIndex(); public native NppiContourPixelGeometryInfo nReverseOrderIndex(int setter);
    /** index of first ordered contour pixel in this subgroup */
    public native @Cast("Npp32u") int nFirstIndex(); public native NppiContourPixelGeometryInfo nFirstIndex(int setter);
    /** index of last ordered contour pixel in this subgroup */
    public native @Cast("Npp32u") int nLastIndex(); public native NppiContourPixelGeometryInfo nLastIndex(int setter);
    /** index of next ordered contour pixel in NppiContourPixelGeometryInfo list */
    public native @Cast("Npp32u") int nNextContourPixelIndex(); public native NppiContourPixelGeometryInfo nNextContourPixelIndex(int setter);
    /** index of previous ordered contour pixel in NppiContourPixelGeometryInfo list */
    public native @Cast("Npp32u") int nPrevContourPixelIndex(); public native NppiContourPixelGeometryInfo nPrevContourPixelIndex(int setter);
    /** this test pixel is has already been used */
    public native @Cast("Npp8u") byte nPixelAlreadyUsed(); public native NppiContourPixelGeometryInfo nPixelAlreadyUsed(byte setter);
    /** this test pixel is already linked to center pixel */
    public native @Cast("Npp8u") byte nAlreadyLinked(); public native NppiContourPixelGeometryInfo nAlreadyLinked(byte setter);
    /** this pixel has already been output in geometry list */
    public native @Cast("Npp8u") byte nAlreadyOutput(); public native NppiContourPixelGeometryInfo nAlreadyOutput(byte setter);
    /** direction of contour region interior */
    public native @Cast("Npp8u") byte nContourInteriorDirection(); public native NppiContourPixelGeometryInfo nContourInteriorDirection(byte setter);
}
