// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * External semaphore handle descriptor
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 position(long position) {
        return (CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1)super.position(position);
    }
    @Override public CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 getPointer(long i) {
        return new CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1((Pointer)this).offsetAddress(i);
    }

    /**
     * Type of the handle
     */
    public native @Cast("CUexternalSemaphoreHandleType") int type(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 type(int setter);
        /**
         * File descriptor referencing the semaphore object. Valid
         * when type is one of the following:
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD
         */
        @Name("handle.fd") public native int handle_fd(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 handle_fd(int setter);
        /**
         * Win32 handle referencing the semaphore object. Valid when
         * type is one of the following:
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32
         * Exactly one of 'handle' and 'name' must be non-NULL. If
         * type is one of the following:
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT
         * - ::CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT
         * then 'name' must be NULL.
         */
            /**
             * Valid NT handle. Must be NULL if 'name' is non-NULL
             */
            @Name("handle.win32.handle") public native Pointer handle_win32_handle(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 handle_win32_handle(Pointer setter);
            /**
             * Name of a valid synchronization primitive.
             * Must be NULL if 'handle' is non-NULL.
             */
            @Name("handle.win32.name") public native @Const Pointer handle_win32_name(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 handle_win32_name(Pointer setter);
        /**
         * Valid NvSciSyncObj. Must be non NULL
         */
        @Name("handle.nvSciSyncObj") public native @Const Pointer handle_nvSciSyncObj(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 handle_nvSciSyncObj(Pointer setter);
    /**
     * Flags reserved for the future. Must be zero.
     */
    public native @Cast("unsigned int") int flags(); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 flags(int setter);
    public native @Cast("unsigned int") int reserved(int i); public native CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1 reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
}
