/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.bsc.maven.plugin.processor.AbstractAnnotationProcessorMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="process", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MainAnnotationProcessorMojo
extends AbstractAnnotationProcessorMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List classpathElements;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/apt", required=true)
    private File defaultOutputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputClassDirectory;

    @Override
    public Set<File> getSourceDirectories() {
        List sourceRoots = this.project.getCompileSourceRoots();
        HashSet<File> result = new HashSet<File>(sourceRoots.size() + 1);
        result.add(this.sourceDirectory);
        for (String s : sourceRoots) {
            result.add(new File(s));
        }
        return result;
    }

    @Override
    protected File getOutputClassDirectory() {
        return this.outputClassDirectory;
    }

    @Override
    protected void addCompileSourceRoot(MavenProject project, String dir) {
        project.addCompileSourceRoot(dir);
    }

    @Override
    public File getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    @Override
    protected Set<String> getClasspathElements(Set<String> result) {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource r : resources) {
                result.add(r.getDirectory());
            }
        }
        result.addAll(this.classpathElements);
        return result;
    }
}

