/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif.chem;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;

public enum ResidueType implements Serializable
{
    atomn(null, "null"),
    dPeptideLinking(PolymerType.dpeptide, "D-peptide linking"),
    lPeptideLinking(PolymerType.peptide, "L-peptide linking"),
    glycine(PolymerType.peptide, "PEPTIDE LINKING"),
    peptideLike(PolymerType.otherPolymer, "peptide-like"),
    dPeptideAminoTerminus(PolymerType.dpeptide, "D-peptide NH3 amino terminus"),
    lPeptideAminoTerminus(PolymerType.peptide, "L-peptide NH3 amino terminus"),
    dPeptideCarboxyTerminus(PolymerType.dpeptide, "D-peptide COOH carboxy terminus"),
    lPeptideCarboxyTerminus(PolymerType.peptide, "L-peptide COOH carboxy terminus"),
    dnaLinking(PolymerType.dna, "DNA linking"),
    rnaLinking(PolymerType.rna, "RNA linking"),
    dna3PrimeTerminus(PolymerType.dna, "DNA OH 3 prime terminus"),
    rna3PrimeTerminus(PolymerType.rna, "RNA OH 3 prime terminus"),
    dna5PrimeTerminus(PolymerType.dna, "DNA OH 5 prime terminus"),
    rna5PrimeTerminus(PolymerType.rna, "RNA OH 5 prime terminus"),
    dSaccharide(PolymerType.polysaccharide, "D-saccharide"),
    dSaccharide14and14linking(PolymerType.polysaccharide, "D-saccharide 1,4 and 1,4 linking"),
    dSaccharide14and16linking(PolymerType.polysaccharide, "D-saccharide 1,4 and 1,6 linking"),
    lSaccharide(PolymerType.lpolysaccharide, "L-saccharide"),
    lSaccharide14and14linking(PolymerType.lpolysaccharide, "L-saccharide 1,4 and 1,4 linking"),
    lSaccharide14and16linking(PolymerType.lpolysaccharide, "L-saccharide 1,4 and 1,6 linking"),
    saccharide(PolymerType.polysaccharide, "saccharide"),
    dBetaPeptideCGammaLinking(PolymerType.dpeptide, "D-beta-peptide, C-gamma linking"),
    dGammaPeptideCDeltaLinking(PolymerType.dpeptide, "D-gamma-peptide, C-delta linking"),
    lBetaPeptideCGammaLinking(PolymerType.peptide, "L-beta-peptide, C-gamma linking"),
    lGammaPeptideCDeltaLinking(PolymerType.peptide, "L-gamma-peptide, C-delta linking"),
    lDNALinking(PolymerType.dna, "L-DNA linking"),
    lRNALinking(PolymerType.dna, "L-RNA linking"),
    nonPolymer(null, "non-polymer"),
    otherChemComp(null, "other");

    static Map<String, ResidueType> lookupTable;
    public final PolymerType polymerType;
    public final String chem_comp_type;

    private ResidueType(PolymerType pt, String chem_comp_type) {
        this.polymerType = pt;
        this.chem_comp_type = chem_comp_type;
    }

    public PolymerType getPolymerType() {
        return this.polymerType;
    }

    public static ResidueType getResidueTypeFromString(String chem_comp_type) {
        if (chem_comp_type.equalsIgnoreCase(ResidueType.lPeptideLinking.chem_comp_type)) {
            return lPeptideLinking;
        }
        ResidueType rtype = lookupTable.get(chem_comp_type);
        if (rtype != null) {
            return rtype;
        }
        rtype = lookupTable.get(chem_comp_type.toLowerCase());
        if (rtype != null) {
            return rtype;
        }
        for (ResidueType rt : ResidueType.values()) {
            if (rt.chem_comp_type.equalsIgnoreCase(chem_comp_type)) {
                return rt;
            }
            if (rt.chem_comp_type.toLowerCase().startsWith(chem_comp_type.toLowerCase())) {
                return rt;
            }
            if (!chem_comp_type.toLowerCase().startsWith(rt.chem_comp_type.toLowerCase())) continue;
            return rt;
        }
        return null;
    }

    static {
        lookupTable = new HashMap<String, ResidueType>();
        for (ResidueType rt : ResidueType.values()) {
            lookupTable.put(rt.chem_comp_type, rt);
            lookupTable.put(rt.chem_comp_type.toLowerCase(), rt);
        }
    }
}

