/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.PDBFileParser;

public class PDBFileReader
extends LocalPDBDirectory {
    public static final String[] PDB_SPLIT_DIR = new String[]{"data", "structures", "divided", "pdb"};
    public static final String[] PDB_OBSOLETE_DIR = new String[]{"data", "structures", "obsolete", "pdb"};

    public PDBFileReader() {
        this(null);
    }

    public PDBFileReader(String path) {
        super(path);
        this.addExtension(".ent");
        this.addExtension(".pdb");
        this.addExtension(".ent.gz");
        this.addExtension(".pdb.gz");
        this.addExtension(".ent.Z");
        this.addExtension(".pdb.Z");
    }

    @Override
    protected String getFilename(String pdbId) {
        return "pdb" + pdbId.toLowerCase() + ".ent.gz";
    }

    @Override
    public Structure getStructure(InputStream inStream) throws IOException {
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(this.getFileParsingParameters());
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    @Override
    protected String[] getSplitDirPath() {
        return PDB_SPLIT_DIR;
    }

    @Override
    protected String[] getObsoleteDirPath() {
        return PDB_OBSOLETE_DIR;
    }
}

